##synteny

synteny is a program that reconstructs genome architecture from a clustering file generated by the program [usearch](http://drive5.com/usearch/). Output of the 
program consists of two files that describe the synteny in a text format that can be viewed in Excel and also in a .dot format.

### Running synteny

In order to run synteny you need to

1. Cluster the proteins using usearch. We use usearch64 with the parameters -evalue 0.0001 -maxhits 1 -ublast -blast6out.
2. Run synteny

For running synteny use the following command:

```
$ <path-to-synteny-directory>/code/find-synteny.pl
```

You can get a description of the parameters taken by synteny by running this command without parameters:

```
$ code/find-synteny.pl

Usage: /home/itaish/software/GitHub/synteny/code/find-synteny.pl <uclust-file> <connection-threshold> <out-dir> <out-prefix>
```
Where
* **\<uclust-file\>** is the uclust file
* **\<connection-threshold\>** - minimum cluster size required for the cluster to be considered (we use 2)
* **\<out-dir\>** - output directory for files generated by the program
* **\<out-prefix\>** - prefix for output file names under the output directory

### Output
Output consists of the following files:
* **\<out-prefix\>.excel.txt** - a text file with complete description of the syntenic regions detected (see format below)
* **\<out-prefix\>.graph.dot** - a .dot file that describes the gene architecture
* **log-files** - a directory that contains log file to be used for debugging


**\<out-prefix\>.excel.txt** consists of lines of the following formats:

**Headers**, start new syntenic regions and contain information about them. For example:
```
### METACOMPONENT_1000015 (167027 bps, 165.046825396825 genes, 151 backbone genes) ###
```
In this case METACOMPONENT_1000015 is the identifier of the new region, the estimated size for the region is 167,027 bps and it contains 165 genes on 
average of which 151 genes are backbone genes (namely they appear in all sequences analyzed).

**Gene lines**, for example:
```
231 	BACKBONE	+	1498.5	2
360 	BACKBONE	-	1015	3	2	1	86
1283	BUBBLE	-	263	3
```
where fields are 

1. Cluster id
2. Gene type, either BACKBONE (the gene appear on all sequences) or BUBBLE (the gene appears only on some sequences).
3. Strand (+/-) 
4. Number of copies for this gene 
5. Number of times this gene was found together with the previous gene
6. Average number of genes between this and previous BACKBONE gene (including BUBBLEs) 
7. Average distance (in bps) between this and the previous BACKBONE gene. 

### example

Can be found in the directory example. Use the command line in the file run for running the example. example/output contains the expected output.

### How to cite
Comming soon

### License
Copyright (C) 2014 Itai Sharon

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), 
to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
