##Lola

This repository contains the code for the program Lola which assembles Moleculo reads (now called Illumina TruSeq synthetic reads).
Important note: our results show that minimus2 from the AMOS package does a better job in assembling Moleculo long reads and it is also much faster and easy to 
use. We therefore recommend that you use Minimus2 instead of Lola for this purpose. If you do choose to use Lola then here are some instructions.

### Running Lola

The process of assembling long reads with Lola consists of the following two steps:

1. Determining overlaps between the reads using the [program overlap](https://github.com/CK7/overlap), and
2. Running Lola

For running overlap refer to the README file for the overlap project.
For running Lola use the following command:

```
$ <path-to-Lola-directory>/assemble.pl
```

You can get a description of the parameters taken by Lola by running this command without parameters:

```
$ ./assemble.pl 

Usage: ./assemble.pl [-p <% identity threshold] <sequence-file> <connection-file1> [... <connection-filen>] <out-prefix>
```

Parameters are:

* **% identity threshold** - minimum % identity to be used by Lola for considering overlaps between reads. 
* **sequence file** - that's the file with the reads you want to assemble 
* **connection-file** - that's the output file from the program overlap
* **out-prefix** - prefix for names of files that will be generated by Lola.

### Lola output
Output consists of the following files:

* **\<out-prefix\>.fna** - File with both assembled contigs and unassembled reads. Assembled reads and reads contained in other reads are excluded from this file.
* **\<out-prefix\>.gff** - mapping of reads to assembled contigs and other reads (in case a read is contained within another read).
* **\<out-prefix\>.log** - a log file describing the assembly decision making process.
* **\<out-prefix\>.progress.log** - another log file with debugging information.

### example

The directory example under this repository contains an example for how to run Lola. Modify path to Lola and overlap in the run file under this directory and 
then do

```
$ example/run
```

Check example/output for what the directory should look like after run finishes.

### How to cite
Comming soon

### License
Copyright (C) 2014 Itai Sharon

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), 
to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
DEALINGS IN THE SOFTWARE.
