#!/usr/bin/perl -w
#A perl function to calculate the number of sequences with nucleosomes
#file1 the file contains the nucleosome position
#file2 the file contains the coordinate of the sequences
#size1, the length needs to be count on the left of the coordinate
##size2, the length needs to be count on the right of the coordinate
use strict;
use Getopt::Long;
use warnings; 
use Bio::SeqIO;
my $file1;
my $file2;
my $output = "";
my $num1 =0;
my $num2 =0;
if(!@ARGV)
{
	print "$0:  A perl function to calculate the number of sequences of each nucleotide  with nucleosomes for given coordinates\n";
         print "Author:  Shaofang Li, UC Riverside\n";
         print "Contact:  Shaofang Li <sfli001\@gmail.com>\n";
        print "\nUsage: $0 [options]\n";
        print "\tfile1: input file contains the nucleosome position\n";
        print "\tfile2: input file contains the coordinate of the sequences\n";
        print "\tsize1: the length needs to be count on the left of the coordinate\n";
        print "\tsize2: the length needs to be count on the right of the coordinate\n";
        print "\to: the output file\n";
	
	print "\nExample:\n";
	print "$0 --file1 nucleosome_coor --file2 DNA_coor --size1 1000 --size2 200 -o output
\n";
	print ("==========================| $0  end  |==================================\n\n");
	exit 1;
}
GetOptions("file1=s" =>\$file1,"file2=s"=>\$file2,"size1=i"=>\$num1,"size2=i"=>\$num2, "o=s" =>\$output);

my %hash;
#function to establish empty hash
open(SAM1, $file1);
	while(<SAM1>)
	{
		my ($re)= $_;
		my @read = split("\t", $re);
		for(my $count = $read[1]; $count<= $read[2]; $count++)
		{
		
			$hash{$read[0]}{$count}+=1;
		}
	}
my %result;
my $num = $num1 + $num2 + 1;
for(my $count = 1; $count<= $num; $count++)
{
 $result{$count}= 0;
}

open(SAM2, $file2);
while(<SAM2>)
{
                my ($re)= $_;
                my @read = split("\t", $re);
		for(my $count = 1; $count<= $num; $count++)
	
                {
			
			if(exists($hash{$read[0]}{$read[1]-1- $num1+ $count}))
			{
			$result{$count}+= $hash{$read[0]}{$read[1]-1-$num1 + $count};
                  	}
                }
}

open(OUT, ">$output");
 
my $k1;
foreach  $k1 (sort{$a<=>$b} keys%result)
{	
	print OUT  $k1,"\t",$result{$k1} ,"\n";
}


exit;
