#!/bin/sh

GHOME="/nlmusr/gchirn/linux"
RHOME="/nlmusr/reazur/linux"
HOME=$GHOME

#prefix=$1
###################################
##  align to masked genome and remove those sequences
###################################


mismatch=1
database="/nlmusr/reazur/linux/NELSON/Genome_resequence/dm3_mask"
#database="/nlmusr/gchirn/linux/UCSC_GENOME/fly/ucsc_fly_genome"
input=$1
output=$input".gen.sam"
$GHOME/TOOLS/bin/bowtie -f -v $mismatch -S -k 100000 -m 100000 --strata --best -p 12 $database $input $output

perl $RHOME/CORE/separate_aligned_unaligned.pl -f $input -s $output 
mv $input.al $input.gen
mv $input.ual $input.nogen

$RHOME/CORE/writeqc.sh $input $input.gen match_dm3_mask_gen":$mismatch"
#$RHOME/CORE/writeqc.sh $input $input.gen match_dm3_unmask_gen":$mismatch"


###################################
##  align to consensus TE
###################################


mismatch=2
database="/nlmusr/reazur/linux/NELSON/Genome_resequence/dm_TE"
input=$1
output=$input".TE.sam"
$GHOME/TOOLS/bin/bowtie -f -v $mismatch -S -k 100000 -m 100000 --strata --best -p 12 $database $input $output


perl $RHOME/CORE/separate_aligned_unaligned.pl -f $input -s $output 
mv $input.al $input.TE
mv $input.ual $input.noTE

$RHOME/CORE/writeqc.sh $input $input.TE match_dm3_TE":$mismatch"

##########################################################

