#!/bin/sh
plot_window_size=1
mismatch=1

HOME="/nlmusr/gchirn/linux"
RHOME="/nlmusr/reazur/linux"

database=$2
#doumentation test for qc
text=$3
#database="kawaoka_transposon"
#database=$RHOME"/NELSON/Genome_resequence/essential_gene/essential_gene_db"


#input = s2768.fastq or somethign similar


input=$1
#-------------
$HOME/TOOLS/bin/bowtie -f -v $mismatch -S -k 100000 -m 100000 --strata --best -p 12 $database $input z0.$1

output=z0.$1

#--------------------
perl $RHOME/CORE/separate_aligned_unaligned.pl -f $input -s $output 
mv $input.al $input.mapped
mv $input.ual $input.unmapped

#write qc
$RHOME/CORE/writeqc.sh $input $input.mapped $text
#------------------------------------------

#touch z1.$1
grep '^@' z0.$1 > $1.rep.sam
cat z0.$1 | grep -v '^@' | grep -v '	4	\*	0	0	\*	\*	0	0	' | sort -u -T /nlmusr/reazur/linux/tmp >> $1.rep.sam

echo -n "$1	reads mapped (from sam file)	" >> summary; 
grep -v '^@' $1.rep.sam | cut -f1 | sort -u | cut -d':' -f2 | $HOME/CORE/bin/sum >> summary

echo "Done with first part"

#############################
## make bed file   
#############################
grep    '^@' $1.rep.sam > z5.$1
grep -v '^@' $1.rep.sam | grep '[ACTGN][ACTGN]*:[0-9][0-9]*	0	' >> z5.$1
grep    '^@' $1.rep.sam > z6.$1
grep -v '^@' $1.rep.sam | grep '[ACTGN][ACTGN]*:[0-9][0-9]*	16	' >> z6.$1
$HOME/TOOLS/bin/samtools view -bS z5.$1 > z7.$1
$HOME/TOOLS/bin/bamToBed -i z7.$1 > z8.$1
cut -f2,3 z8.$1 | paste z8.$1 - | sed 's/$/	255,0,0/' > z9.$1
$HOME/TOOLS/bin/samtools view -bS z6.$1 > z7.$1
$HOME/TOOLS/bin/bamToBed -i z7.$1 > z8.$1
cut -f2,3 z8.$1 | paste z8.$1 - | sed 's/$/	0,0,255/' >> z9.$1
echo "track name=\"$1\" description=\"$1\" visibility=2 itemRgb=\"On\"" > $1.rep.bed
sort -T ./ +0 -1 +1 -2n +2 -3n z9.$1 >> $1.rep.bed
#exit;

echo "Bed files created"


echo -n "$1 mapped (from bed file) " >> summary
grep -v '^track' $1.rep.bed | grep -v '^virus=' | cut -f4 | sort -u | cut -d':' -f2 | $HOME/CORE/bin/sum >> summary

cp summary summary.txt

exit


