/* filtsites1.c - Takes output from filtered vcf files and outputs list of 
chr pos of sites with homozygous reference calls with DP >= x.  Usage:

grep 0/0 NS3.vcf | awk '{print $1" "$2" "$NF}' | filtsites1 x

*/

#include <stdio.h>
#include <stdlib.h>

int main (int argc, char *argv[])
{
  int a, x, chr, pos;

  if (argc != 2) {
    printf("Usage: filtsites x\n");
    exit(0);
  }
  x = atoi (argv[1]);

  while (scanf ("chr%d %d 0/0:%d\n", &chr, &pos, &a) != EOF)
    if (a>=x)
      printf("%d %d\n", chr, pos);
}
