/* filtshortvcf2.c - Takes output from 'in1' (e.g., NS-1_short1.vcf) and 
outputs for each SNP
chr position genotype1 genotype2 GQ

where GQ = genotype quality

Usage: filtshortvcf2

*/

#include <stdio.h>
#include <stdlib.h>
#define SMAX 500000
int main (int argc, char *argv[])
{
  int a, b, s=0, postemp, A1, A2, *pos, chr, posold = -1;
  int chrold, A1old, A2old, flag;
  double X, gq, gqold;
  char **list;

  if (argc != 1) {
    printf("Usage: filtshortvcf2\n");
    exit(0);
  }

  scanf ("chr%d %d %d/%d:%*d,%*d:%*d:%lf:%*d,%*d,%*d\n", &chrold, &posold, &A1old,
	 &A2old, &gqold);

  while (scanf ("chr%d %d %d/%d:%*d,%*d:%*d:%lf:%*d,%*d,%*d\n", &chr, &postemp, &A1, 
		&A2, &gq) != EOF) {
    if (postemp == posold) {
      flag = 1;
      while (flag) {
	scanf ("chr%d %d %d/%d:%*d,%*d:%*d:%lf:%*d,%*d,%*d\n", &chr, &postemp, &A1,
	       &A2, &gq); 
	if (postemp != posold)
	  flag = 0;
      }
      chrold = chr; posold = postemp;
      A1old = A1; A2old = A2; gqold = gq;
    }
    else {
      printf("%d %d %d %d %lf\n", chrold, posold, A1old, A2old, gqold);
      chrold = chr; posold = postemp;
      A1old = A1; A2old = A2; gqold = gq;
    }
  }
}
