/* add1KGfreq.c - Takes a .geno file and a file of 1KG frequencies and appends
the 1KG (European) frequency as the final field on each line.  Usage:

add1KGfreq n genofile OneKGfile

n = number of individuals
genofile = .geno file where $1 = chr #, $2 = position, next 2n fields are 
  genotype calls (0 or 1), and final n fields are doubles with quality scores.
OneKGfile = file with 1KG frequencies (e.g., CEUfreq1)
*/

#include <stdio.h>
#include <stdlib.h>

int main (int argc, char *argv[])
{
  int a, b, n, *s, pos1, pos2, chr, chr2, flag;
  FILE *genofile, *OneKGfile;
  double *qual, freq, freq2;

  if (argc != 4) {
    printf("Usage: add1KGfreq n genofile 1KGfile\n");
    exit(0);
  }
  n = atoi (argv[1]);
  s = (int *) malloc (2 * n * sizeof (int));
  qual = (double *) malloc (n * sizeof (double));

  genofile = fopen (argv[2], "r");

  while (fscanf (genofile, "%d ", &chr) != EOF) {
    fscanf (genofile, "%d ", &pos1);
    for (a=0; a<(2*n); ++a)
      fscanf (genofile, "%d ", &s[a]);
    for (a=0; a<n; ++a)
      fscanf (genofile, "%lf ", &qual[a]);

    OneKGfile = fopen (argv[3], "r");
    freq = 0.; flag = 0;
    while (flag == 0 && fscanf (OneKGfile, "%d %d %lf\n", &chr2, &pos2, &freq2) != EOF)
      if (chr2 == chr && pos1 == pos2) {
	freq = freq2;
	flag = 1;
      }
    fclose (OneKGfile);

    printf("%d %d ", chr, pos1);
    for (a=0; a<(2*n); ++a)
      printf("%d ", s[a]);
    for (a=0; a<n; ++a)
      printf("%.4f ", qual[a]);
    printf("%.3f\n", freq);
  }
}
