function mutated_elements = SynLibProducePalindromeMutatedPSSMElements(pssm_element,cur_pssm_element_str)
%function mutated_elements = SynLibProducePalindromeMutatedPSSMElements(pssm_element,cur_pssm_element_str)

tokens = regexp(cur_pssm_element_str,'_', 'split');

first_pos = str2num(tokens{4});
second_pos = str2num(tokens{5});

seq = pssm_element.Sequence;
seq_len = length(seq);

mutated_elements =  cell(1,1);

all_mutated_seqs = SynLibGetAllFullyMutateSeqs(seq([first_pos second_pos]));

all_mutated_seqs = all_mutated_seqs(randperm(length(all_mutated_seqs)));


for m=1:length(all_mutated_seqs)


    if IsPalindromeSeq(all_mutated_seqs{m})

        cur_element = pssm_element;
        cur_element.SubType = [cur_element.SubType 'p_' strrep(num2str([first_pos second_pos]),' ','') '_m' all_mutated_seqs{m}];
        cur_element.Sequence = seq;
        cur_element.Sequence([first_pos second_pos]) = all_mutated_seqs{m};

        mutated_elements{1} = cur_element;
        break;
    end
end





