function mutated_elements = SynLibProduceMutatedPSSMElements(pssm_element,cur_pssm_element_str)
%function mutated_elements = SynLibProduceMutatedPSSMElements(pssm_element,cur_pssm_element_str)

tokens = regexp(cur_pssm_element_str,'_', 'split');

num_mutated_pos = str2num(tokens{3});
num_mutation_in_pos = str2num(tokens{4});

all_mutations_pos = true;
total_mutations_num = nan;

if num_mutation_in_pos < 0
    all_mutations_pos = false;
    total_mutations_num = abs(num_mutation_in_pos);
    num_mutation_in_pos = 1;
end


seq = pssm_element.Sequence;
seq_len = length(seq);

all_posible_mutation_pos = nchoosek(1:seq_len,num_mutated_pos);

if all_mutations_pos
    mutation_positions = all_posible_mutation_pos;

else
    chosen_mut_ind = randperm(size(all_posible_mutation_pos,1));

    mutation_positions = all_posible_mutation_pos(chosen_mut_ind(1:total_mutations_num),:);
end

mutations_pos_num = size(mutation_positions,1);


mutated_elements =  cell(1,mutations_pos_num*num_mutation_in_pos);
i=1;
for p=1:mutations_pos_num


    all_mutated_seqs = SynLibGetAllFullyMutateSeqs(seq(mutation_positions(p,:)));

    all_mutated_seqs = all_mutated_seqs(randperm(length(all_mutated_seqs)));


    all_mutated_seqs = all_mutated_seqs(1:num_mutation_in_pos);

    for m=1:length(all_mutated_seqs)



        cur_element = pssm_element;
        cur_element.SubType = [cur_element.SubType 'p_' strrep(num2str(mutation_positions(p,:)),' ','') '_m' all_mutated_seqs{m}];
        cur_element.Sequence = seq;
        cur_element.Sequence(mutation_positions(p,:)) = all_mutated_seqs{m};
        
        mutated_elements{i} = cur_element;
        i=i+1;
    end

end



