function [reg_elements_array, reg_elements_struct, reg_elements_by_name_struct] = SynLibLoadRegElements(elements_file_name)
%function [reg_elements_array, reg_elements_struct, reg_elements_by_name_struct] = SynLibLoadRegElements(elements_file_name)
% reads synthetic library elements file

elements_struct = LoadTab2Struct(elements_file_name);

num_elements = length(elements_struct.(elements_struct.prop{1}));
num_properties = length(elements_struct.prop);

reg_elements_array = cell(num_elements,1);
reg_elements_struct = struct;
reg_elements_by_name_struct = struct;
for e=1:num_elements
    cur_element = struct;
    for p=1:num_properties
     cur_element.(elements_struct.prop{p}) = elements_struct.(elements_struct.prop{p}){e};
    end
    reg_elements_array{e} = cur_element;
    if isfield(reg_elements_struct, [cur_element.SubType '__' cur_element.Strength '__' cur_element.Orientation])
        error(['SynLibLoadRegElements  element already exist: ' cur_element.SubType '__' cur_element.Strength '__' cur_element.Orientation]);
    else
        reg_elements_struct.([cur_element.SubType '__' cur_element.Strength '__' cur_element.Orientation]) = cur_element;
    end
    if isfield(reg_elements_by_name_struct, cur_element.Name)
        error(['SynLibLoadRegElements  element already exist: ' cur_element.Name]);
    else
        reg_elements_by_name_struct.(cur_element.Name) = cur_element;
    end
    clear cur_element;
end
