function [vecs_array vecs_struct]  = SynLibLoadPosVecFile(vec_file_name)


vecs_array = cell(0,1);
vecs_struct = struct;


fid = fopen(vec_file_name,'r');

if fid < 0
    error(['File ' , vec_file_name ,' was not found.']);
end

line_index = 0;
while feof(fid)==0


    tline = fgetl(fid);

    if ~ischar(tline)
        break;
    end

    line_index = line_index + 1;

    if(mod(line_index,100) == 0)
        disp(['SynLibLoadPosVecFile parsing line:' num2str(line_index)]);
    end

    tokens = regexp(tline,'\t', 'split');
    
    tokens = strtrim(tokens);
    
    % comment line
    if isempty(tokens) || tokens{1}(1) == '#' || isempty(tokens{1})
        continue;
    end
    
    cur_vec_name = tokens{1};
    cur_vec_num_p = str2num(tokens{2});
    cur_vec_min_pos = str2num(tokens{3});
    cur_vec_max_pos = str2num(tokens{4});
    
    cur_vec = [];
    for i=5:length(tokens)
        if ~isempty(tokens{i}) && ~isempty(str2num(tokens{i}))
            cur_vec(end+1) = str2num(tokens{i});
        end
            
    end
    
    cur_struct = struct;
    cur_struct.Name = cur_vec_name;
    cur_struct.Num_p = cur_vec_num_p;
    cur_struct.Min_pos = cur_vec_min_pos;
    cur_struct.Max_pos= cur_vec_max_pos;
    cur_struct.Positions = cur_vec;
    
    
    vecs_array{end+1} = cur_struct;
    if isfield(vecs_struct, cur_vec_name)
        error(['SynLibLoadPosVecFile vector already exist:' cur_vec_name ', line:' num2str(line_index)]);
    else
        vecs_struct.(cur_vec_name) = cur_struct;
    end
    
    
   
end
    
    
    