function [construct_set_array]  = SynLibLoadConstructSetFile(construct_set_file_name)
%function [construct_set_array]  = SynLibLoadConstructSetFile(construct_set_file_name)


construct_set_array = cell(0,1);



fid = fopen(construct_set_file_name,'r');

if fid < 0
    error(['File ' , construct_set_file_name ,' was not found.']);
end

line_index = 0;
while feof(fid)==0
    
    
    tline = fgetl(fid);
    
    if ~ischar(tline)
        break;
    end
    
    line_index = line_index + 1;
    
    if(mod(line_index,100) == 0)
        disp(['SynLibLoadConstructSetFile parsing line:' num2str(line_index)]);
    end
    
    tokens = regexp(tline,'\t', 'split');
    
    tokens = strtrim(tokens);
    
    tokens = tokens(~cellfun(@isempty,tokens));
    
    % comment line
    if isempty(tokens) || isempty(tokens{1}) || tokens{1}(1) == '#'
        continue;
    end
    
    if strcmp(tokens{1},'SET')
        
        if exist('cur_set','var')
            construct_set_array{end+1} = cur_set;
            clear cur_set;
        end
        
        cur_set = struct;
        cur_set.Context = {};
        cur_set.Element = {};
        
        cur_set.Name = '';
        % important to add properties defualts here
        cur_set.DuplicateNum = 1;
        
        if length(tokens) > 1
            cur_set.Name = tokens{2};
        end
        
        if length(tokens) > 2
            cur_set_prop_str = tokens{3};
            cur_prop_tokens = regexp(cur_set_prop_str,';', 'split');
            for t=1:length(cur_prop_tokens)
                cur_prop_tok = regexp(cur_prop_tokens{t},'\s*(\S)+=(\S)+\s*','tokens');
                if length(cur_prop_tok) ~=1
                    error(['SynLibLoadConstructSetFile bad set properties format, line ' num2str(line_index) ':' tline]);
                end
                if length(cur_prop_tok{1}) ~= 2
                    error(['SynLibLoadConstructSetFile bad set properties format (2), line ' num2str(line_index) ':' tline]);
                end
                
                cur_prop = cur_prop_tok{1}{1};
                cur_val = cur_prop_tok{1}{2};
                % important to add numeric properties here
                if ismember(cur_prop,{'DuplicateNum'})
                    cur_val = str2num(cur_val);
                end
                cur_set.(cur_prop) = cur_val;
            end
        end

        continue;
        
    elseif strcmp(tokens{1},'ELEMENT')
        
        if ~exist('cur_set','var')
            error(['SynLibLoadConstructSetFile element appear out of set, line' num2str(line_index) ':' tline]);
        end
        
        cur_element = struct;
        
        if length(tokens) ~= 5
            error(['SynLibLoadConstructSetFile element does contain right number of fields, line' num2str(line_index) ':' tline]);
        end
        
        if isempty(tokens{2})
            error(['SynLibLoadConstructSetFile empty SubType (2), line' num2str(line_index) ':' tline]);
        end
        
        cur_sub_types = regexp(tokens{2},',', 'split');
        cur_sub_types = strtrim(cur_sub_types);
        cur_element.SubType = cur_sub_types;
        clear cur_sub_types;
        
        if isempty(tokens{3})
            error(['SynLibLoadConstructSetFile empty Strength (3), line' num2str(line_index) ':' tline]);
        end
        
        cur_strength = regexp(tokens{3},',', 'split');
        cur_strength = strtrim(cur_strength);
        cur_element.Strength = cur_strength;
        clear cur_strength;
        
        if isempty(tokens{4})
            error(['SynLibLoadConstructSetFile empty Orientation (4), line' num2str(line_index) ':' tline]);
        end
        
        cur_orientation = regexp(tokens{4},',', 'split');
        cur_orientation = strtrim(cur_orientation);
        cur_element.Orientation = cur_orientation;
        clear cur_orientation;
        
        if isempty(tokens{5})
            error(['SynLibLoadConstructSetFile empty PosVec (5), line' num2str(line_index) ':' tline]);
        end
        
        cur_pos_vec = regexp(tokens{5},',', 'split');
        cur_pos_vec = strtrim(cur_pos_vec);
        cur_element.PosVec = cur_pos_vec;
        clear cur_pos_vec;
        
        
        cur_set.Element{end+1} = cur_element;
        
    elseif strcmp(tokens{1},'CONTEXT')
        
        if ~exist('cur_set','var')
            error(['SynLibLoadConstructSetFile context appear out of set, line' num2str(line_index) ':' tline]);
        end
        
        
        
        if length(tokens) ~= 2
            error(['SynLibLoadConstructSetFile context does contain right number of fields, line' num2str(line_index) ':' tline]);
        end
        
        if isempty(tokens{2})
            error(['SynLibLoadConstructSetFile empty contexts (2), line' num2str(line_index) ':' tline]);
        end
        
        cur_context_set = regexp(tokens{2},',', 'split');
        cur_context_set = strtrim(cur_context_set);
        
        cur_set.Context = [cur_set.Context cur_context_set];
        
        
        clear cur_sub_types;
        
    end
    
    
end


if exist('cur_set','var')
    construct_set_array{end+1} = cur_set;
    clear cur_set;
end


