function fully_mutated_seqs = SynLibGetAllFullyMutateSeqs(seq)
%function fully_mutated_seqs = SynLibGetAllFullyMutateSeqs(seq)

seq_len = length(seq);

fully_mutated_seqs = cell(seq_len*3,1);

mutation_options = repmat('N', 3, seq_len);
    
for i=1:seq_len

    switch seq(i)
        case 'A'
            possible_mutations = 'CGT';
        case 'T'
            possible_mutations = 'ACG';
        case 'C'
            possible_mutations = 'AGT';
        case 'G'
            possible_mutations = 'ACT';
        otherwise
            error(['SynLibGetAllFullyMutateSeqs unknown nucleotide:' seq(i)]);
    end

    mutation_options(:,i) = possible_mutations;

end

fully_mutated_seqs = {};
prev_fully_mutated_seqs = {};

for i=1:seq_len
    %i
    fully_mutated_seqs = {};
    
    for j=1:size(mutation_options,1)
        %j
        if isempty(prev_fully_mutated_seqs)
            fully_mutated_seqs{end+1} = mutation_options(j,i);
        else
            for s=1:length(prev_fully_mutated_seqs)
                %s
                fully_mutated_seqs{end+1} = [prev_fully_mutated_seqs{s} mutation_options(j,i)];
            end
        end
        
    end
    
    prev_fully_mutated_seqs = fully_mutated_seqs;
end




