function mutated_seq = SynLibFullyMutateSeq(seq,  avoid_homogeneous_seq)

is_mutated = false;

mutated_seq = seq;
seq_len = length(seq);
    
while ~is_mutated
    
    cur_rand_nums = ceil(3.*rand(1,seq_len));
    for i=1:seq_len
        
        switch seq(i)
            case 'A'
                possible_mutations = 'CGT';
            case 'T'
                possible_mutations = 'ACG';
            case 'C'
                possible_mutations = 'AGT';
            case 'G'
                possible_mutations = 'ACT';
            otherwise
                error(['SynLibFullyMutateSeq unknown nucleotide:' seq(i) ' in sequence:' seq]);
        end
        
        mutated_seq(i) = possible_mutations(cur_rand_nums(i));

    end
    
    is_mutated = true;
    if avoid_homogeneous_seq && ...
       ( strcmp(mutated_seq,repmat('A',1,seq_len)) || ...
         strcmp(mutated_seq,repmat('C',1,seq_len)) || ...
         strcmp(mutated_seq,repmat('G',1,seq_len)) || ...
         strcmp(mutated_seq,repmat('T',1,seq_len)) )
     is_mutated = false;
    end
    
end
