function construct_array = SynLibConstructSet2ConstructArray(construct_set_array, reg_elements_struct, context_by_name_struct, vecs_struct)
%function construct_array =
%SynLibConstructSet2ConstructArray(construct_set_array, reg_elements_struct, context_by_name_struct, vecs_struct)


disp('--- SynLibConstructSet2ConstructArray start ---');

set_num = length(construct_set_array);
construct_array = {};


for s=1:set_num

    cur_set = construct_set_array{s};
    context_num = length(cur_set.Context);
    
    disp(['SynLibConstructSet2ConstructArray, set num: ' num2str(s) ', set name:' cur_set.Name]);

    if context_num == 0
        error(['SynLibConstructSet2ConstructArray set num ' num2str(s) ' Does NOT contain any context']);
    end
        
    % getting the contexts
    context_array = {};
    for c=1:context_num

        cur_context_name = cur_set.Context{c};
        if ~isfield(context_by_name_struct, cur_context_name)
            error(['SynLibConstructSet2ConstructArray no such context in context struct:' cur_context_name]);
        end
        cur_context = context_by_name_struct.(cur_context_name);

        context_array{end+1} = cur_context;

    end

    disp(['SynLibConstructSet2ConstructArray, context num: ' num2str(length(context_array))]);

    elements_num = length(cur_set.Element);
    element_array_of_vecs = cell(1,elements_num);

    disp(['SynLibConstructSet2ConstructArray' ', set name:' cur_set.Name ', archetype elements num: ' num2str(elements_num)]);

    for e=1:elements_num

        cur_element_details  = cur_set.Element{e};

        element_array_of_vecs{e} = {};

        % Cartesian product of element definitions
        num_sub_types = length(cur_element_details.SubType);
        for st=1:num_sub_types
            num_strength = length(cur_element_details.Strength);
            for sw=1:num_strength
                num_ori = length(cur_element_details.Orientation);
                for ori=1:num_ori

                    if strncmp(cur_element_details.SubType{st},'PSSM_MUTATION_',14)
                        
                        cur_pssm_element_su_type = cur_element_details.SubType{st};
                        cur_pssm_element_su_type1 = cur_pssm_element_su_type(1:(find(cur_pssm_element_su_type == ';')-1));
                        cur_pssm_element_su_type2 = cur_pssm_element_su_type((find(cur_pssm_element_su_type == ';')+1):end);
                        if ~isfield(reg_elements_struct, [cur_pssm_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}])
                            error(['SynLibConstructSet2ConstructArray no such element in elements struct:' cur_pssm_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori} ', set num:' num2str(s)]);
                        end
                        cur_pssm_element = reg_elements_struct.([cur_pssm_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}]);
                        
                        cur_elements = SynLibProduceMutatedPSSMElements(cur_pssm_element,cur_pssm_element_su_type1);
                    
                    elseif strncmp(cur_element_details.SubType{st},'PSSM_PALINDROME_MUTATION_',25)
                        
                        cur_pssm_element_su_type = cur_element_details.SubType{st};
                        cur_pssm_element_su_type1 = cur_pssm_element_su_type(1:(find(cur_pssm_element_su_type == ';')-1));
                        cur_pssm_element_su_type2 = cur_pssm_element_su_type((find(cur_pssm_element_su_type == ';')+1):end);
                        if ~isfield(reg_elements_struct, [cur_pssm_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}])
                            error(['SynLibConstructSet2ConstructArray no such element in elements struct:' cur_pssm_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori} ', set num:' num2str(s)]);
                        end
                        cur_pssm_element = reg_elements_struct.([cur_pssm_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}]);
                        
                        cur_elements = SynLibProducePalindromeMutatedPSSMElements(cur_pssm_element,cur_pssm_element_su_type1);
                    
                    
                    elseif strncmp(cur_element_details.SubType{st},'MULTIPLE_SITES_',15)
                        cur_multi_element_su_type = cur_element_details.SubType{st};
                        cur_multi_element_su_type1 = cur_multi_element_su_type(1:(find(cur_multi_element_su_type == ';')-1));
                        cur_multi_element_su_type2 = cur_multi_element_su_type((find(cur_multi_element_su_type == ';')+1):end);
                        if ~isfield(reg_elements_struct, [cur_multi_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}])
                            error(['SynLibConstructSet2ConstructArray no such element in elements struct:' cur_multi_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori} ', set num:' num2str(s)]);
                        end
                        cur_multi_element = reg_elements_struct.([cur_multi_element_su_type2 '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}]);
                        cur_multi_element.SubType = [ cur_multi_element_su_type1 ';' cur_multi_element.SubType];
                        cur_elements{1} = cur_multi_element;
                        
                    elseif strncmp(cur_element_details.SubType{st},'MULTIMUTATION_',14)
                        cur_multi_element_su_type = cur_element_details.SubType{st};
                        cur_multi_element_su_type1 = cur_multi_element_su_type(1:(find(cur_multi_element_su_type == ';')-1));
                        cur_multi_element_su_type2 = cur_multi_element_su_type((find(cur_multi_element_su_type == ';')+1):end);
                        
                        tokens = regexp(cur_multi_element_su_type1,'_', 'split');
                        cur_mut_len = str2num(tokens{2});
                        cur_elem = struct;
                        cur_elem.Name = cur_multi_element_su_type2;
                        cur_elem.Type = 'MUTATION';
                        cur_elem.SubType = cur_multi_element_su_type1;
                        cur_elem.Strength = 'Strong';
                        cur_elem.Orientation = 'plus';
                        cur_elem.Sequence = repmat('N',1, cur_mut_len);
                        cur_elements{1} = cur_elem;


                    else
                        if ~isfield(reg_elements_struct, [cur_element_details.SubType{st} '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}])
                            error(['SynLibConstructSet2ConstructArray no such element in elements struct:' cur_element_details.SubType{st} '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}]);
                        end
                        cur_elements = {};
                        cur_elements{1} = reg_elements_struct.([cur_element_details.SubType{st} '__' cur_element_details.Strength{sw} '__' cur_element_details.Orientation{ori}]);
                    end
                    
                    
                    
                    for ce=1:length(cur_elements)
                        cur_element =cur_elements{ce};

                        % joining the vecs
                        num_vecs = length(cur_element_details.PosVec);
                        cur_pos_vec = [];
                        for v=1:num_vecs
                            cur_vec_name = cur_element_details.PosVec{v};
                            if ~isfield(vecs_struct, cur_vec_name)
                                error(['SynLibConstructSet2ConstructArray no such vector in vectors struct:' cur_vec_name]);
                            end
                            cur_pos_vec = [cur_pos_vec vecs_struct.(cur_vec_name).Positions];
                        end
                        cur_pos_vec = unique(cur_pos_vec);
                        cur_pos_vec = sort(cur_pos_vec);

                        disp(['SynLibConstructSet2ConstructArray, num positions for archetype element: ' num2str(length(cur_pos_vec))]);


                        % element for each position
                        num_pos_vec = length(cur_pos_vec);
                        
                        if strncmp(cur_element.SubType,'MULTIPLE_SITES_',15)
                            
                            % this is an element that have multiple
                            % positions
                            cur_element_array_of_vecs = cell(1,1);
                            cur_element_with_pos = cur_element;
                            cur_element_with_pos.Start = cur_pos_vec;
                            cur_element_with_pos.End = cur_element_with_pos.Start + length(cur_element_with_pos.Sequence) -1;
                            cur_element_array_of_vecs{1} = cur_element_with_pos;
                        
                        else

                            cur_element_array_of_vecs = cell(1,num_pos_vec);

                            for p=1:num_pos_vec
                                cur_pos = cur_pos_vec(p);
                                cur_element_with_pos = cur_element;
                                cur_element_with_pos.Start = cur_pos;
                                cur_element_with_pos.End = cur_element_with_pos.Start + length(cur_element_with_pos.Sequence) -1;

                                cur_element_array_of_vecs{p} = cur_element_with_pos;

                            end


                        end
                        
                        element_array_of_vecs{e} = [element_array_of_vecs{e} cur_element_array_of_vecs];
                    end

                end
            end
        end

    end

    %%%% Cartesian product of contexts and elements to build constructs
    cur_construct_array = {};

    context_num = length(context_array);
    for c=1:context_num
        cur_construct = struct;
        cur_construct.Context = context_array{c};
        cur_construct.SetName = cur_set.Name;
        cur_construct_array{end+1} = cur_construct;
    end

    elements_vecs_num = length(element_array_of_vecs);

    for ev=1:elements_vecs_num
        prev_construct_array = cur_construct_array;
        cur_construct_array = {};
        cur_element_vec = element_array_of_vecs{ev};

        cur_num_construct = length(prev_construct_array);
        for c=1:cur_num_construct
            cur_construct = prev_construct_array{c};

            cur_elements_num = length(cur_element_vec);
            for e=1:cur_elements_num
                cur_element = cur_element_vec{e};

                cur_construct_with_element = cur_construct;
                if ~isfield(cur_construct_with_element, 'Element')
                    cur_construct_with_element.Element = {};
                end
                
                if strncmp(cur_element.SubType,'MULTIPLE_SITES_',15)
                    
                    cur_multi_element_su_type = cur_element.SubType;
                    cur_multi_element_su_type1 = cur_multi_element_su_type(1:(find(cur_multi_element_su_type == ';')-1));
                    cur_multi_element_su_type2 = cur_multi_element_su_type((find(cur_multi_element_su_type == ';')+1):end);
                    cur_element.SubType = cur_multi_element_su_type2;
                    multiple_sites_constructs = SynLibAddMultiSitesElem2Construct(cur_element, cur_construct_with_element, cur_multi_element_su_type1);
                    cur_construct_array = [cur_construct_array multiple_sites_constructs];
                
                elseif strncmp(cur_element.SubType,'MULTIMUTATION_',14)
                    
                    multiple_mutation_constructs = SynLibAddMultiMutation2Construct(cur_element, cur_construct_with_element);
                    cur_construct_array = [cur_construct_array multiple_mutation_constructs ];

                else
                    cur_construct_with_element.Element{end+1} = cur_element;
                    cur_construct_array{end+1} = cur_construct_with_element;
                end

            end
        end

    end


    % in case a duplicate set - duplicating the set
    if cur_set.DuplicateNum <= 0
        error(['SynLibConstructSet2ConstructArray set duplicate num is not positive, set name:' cur_set.Name]);
    end
    cur_construct_array = repmat(cur_construct_array,1,cur_set.DuplicateNum);
    
                           

    construct_array = [construct_array cur_construct_array];

    disp(['SynLibConstructSet2ConstructArray, set num: ' num2str(s) ', adding ' num2str(length(cur_construct_array)) ' constructs, total after addition: ' num2str(length(construct_array))]);

end


num_construct = length(construct_array);

disp(['SynLibConstructSet2ConstructArray, total num of constructs: ' num2str(num_construct)]);

% sorting the elements
for c=1:num_construct
    construct_array{c} = SynLibSortAConstructElements(construct_array{c});
end

disp('--- SynLibConstructSet2ConstructArray done ---');





