function multiple_sites_constructs = SynLibAddMultiSitesElem2Construct(multi_element, basic_construct, operation_str)
%function multiple_sites_constructs = SynLibAddMultiSitesElem2Construct(multi_element, basic_construct, operation_str)

if ~isfield(basic_construct, 'Element')
    basic_construct.Element = {};
end


tokens = regexp(operation_str,'_', 'split');

operation = tokens{3};
num_sites = str2num(tokens{4});


multiple_sites_constructs = {};

positions_starts = multi_element.Start;
positions_ends = multi_element.End;

num_positions = length(positions_starts);

if num_sites > num_positions
    error(['SynLibAddMultiSitesElem2Construct num sites: ' num2str(num_sites) ' is larger than num of positions: ' num2str(num_positions)]);
end

switch operation
    case {'ALLGROUPOFSIZE', 'ALLGROUPOFSIZES'}

        if strcmp(operation, 'ALLGROUPOFSIZE')
            min_num_sites = num_sites;
            max_num_sites = num_sites;
        else
            min_num_sites = num_sites;
            max_num_sites = str2num(tokens{5});
        end

        for num_sites=min_num_sites:max_num_sites

            if num_sites > num_positions
                error(['SynLibAddMultiSitesElem2Construct (2) num sites: ' num2str(num_sites) ' is larger than num of positions: ' num2str(num_positions)]);
            end

            all_posible_starts_ind = nchoosek(1:num_positions,num_sites);

            for i=1:size(all_posible_starts_ind,1)

                cur_construct = basic_construct;

                for j=1:size(all_posible_starts_ind,2)

                    cur_elem = multi_element;
                    cur_elem.Start = positions_starts(all_posible_starts_ind(i,j));
                    cur_elem.End = positions_ends(all_posible_starts_ind(i,j));

                    cur_construct.Element{end+1} = cur_elem;
                end


                multiple_sites_constructs{end+1} = cur_construct;

            end
        end



    case 'UPTOFROMSTART'

        min_num_sites = num_sites;
        max_num_sites = str2num(tokens{5});


        for num_sites=min_num_sites:max_num_sites

            cur_construct = basic_construct;
            for i=1:num_sites
                cur_elem = multi_element;
                cur_elem.Start = positions_starts(i);
                cur_elem.End = positions_ends(i);
                cur_construct.Element{end+1} = cur_elem;
            end

            multiple_sites_constructs{end+1} = cur_construct;
        end

    case 'UPTOFROMSTART2STEP'

        min_num_sites = num_sites;
        max_num_sites = str2num(tokens{5});
        
        possible_pos_num = length(positions_starts);
        
        pos_ind_to_fill = [1:2:possible_pos_num 2:2:possible_pos_num];


        for num_sites=min_num_sites:max_num_sites

            cur_construct = basic_construct;
            for i=1:num_sites
                cur_elem = multi_element;
                cur_elem.Start = positions_starts(pos_ind_to_fill(i));
                cur_elem.End = positions_ends(pos_ind_to_fill(i));
                cur_construct.Element{end+1} = cur_elem;
            end

            multiple_sites_constructs{end+1} = cur_construct;
        end

    otherwise
        error(['SynLibAddMultiSitesElem2Construct  unknown operation_str:' operation]);
end







