function multiple_mutation_constructs = SynLibAddMultiMutation2Construct(multimut_element, basic_construct)
%function multiple_mutation_constructs = SynLibAddMultiMutation2Construct(multimut_element, basic_construct)


% disp('in SynLibAddMultiMutation2Construct');

tokens = regexp(multimut_element.SubType,'_', 'split');
multimut_element.SubType = tokens{1};
mut_len = str2num(tokens{2});
operation_str = tokens{3};


multiple_mutation_constructs = {};
context_seq_len = length(basic_construct.Context.Sequence);


if multimut_element.Start < 0
    multiple_mutation_constructs = {basic_construct};
    return;
end


if ~ismember(operation_str,{'RandomDNA'})
    org_seq = basic_construct.Context.Sequence(context_seq_len-(multimut_element.End:-1:multimut_element.Start)+1);
end
        
switch operation_str
    case 'FULLMUT'
        mut_num = str2num(tokens{4});
        if mut_num > 3^mut_len
            error(['SynLibAddMultiMutation2Construct num muntations: ' num2str(mut_num) ' is larger than possible mutation in bp len: ' num2str(mut_len)]);
        end
        
        
        if any(org_seq == '-')
             error(['SynLibAddMultiMutation2Construct sequence to mutate contains - : ' org_seq ' start: ' num2str(multimut_element.Start) ', end: ' num2str(multimut_element.End)]);
        end

        if length(org_seq) > 7
            
            if sqrt(3.^length(org_seq)) > mut_num
                % solve iteratively
                mut_seqs = {};
                while length(mut_seqs) < mut_num
                    avoid_homogeneous_seq = false;
                    cur_mutated_seq = SynLibFullyMutateSeq(org_seq,  avoid_homogeneous_seq);
                    if ~ismember(cur_mutated_seq, mut_seqs)
                        mut_seqs{end+1} = cur_mutated_seq;
                    end
                end
            else
                error('TODO - more efficient implementation SynLibAddMultiMutation2Construct');
            end
        else
            all_mutated_seqs = SynLibGetAllFullyMutateSeqs(org_seq);
            all_mutated_seqs = all_mutated_seqs(randperm(length(all_mutated_seqs)));
            
            mut_seqs = all_mutated_seqs(1:mut_num);
        end
        
        for i=1:length(mut_seqs)
            
            cur_construct = basic_construct;

            cur_elem = multimut_element;
            cur_elem.Sequence = mut_seqs{i};
            cur_elem.SubType = [operation_str '_' num2str(i)];
            cur_construct.Element{end+1} = cur_elem;

            multiple_mutation_constructs{end+1} = cur_construct;
            
        end
        
    case 'GCVariants'
        mut_variants_num = str2num(tokens{4});
        gc_variant_seq_struct = CreateRandomGCVariants(org_seq,[1 length(org_seq)],mut_variants_num);
        gc_bin_mut = gc_variant_seq_struct.GC_bin;
        for i=1:length(gc_bin_mut)
            cur_gc_bin_mut = gc_bin_mut(i);
            for j=1:length(cur_gc_bin_mut.variants)
                subset_str = [operation_str '_' strrep(cur_gc_bin_mut.GC, '% ','')  '_' num2str(j)];
                cur_construct = basic_construct;
                cur_elem = multimut_element;
                cur_elem.Sequence = cur_gc_bin_mut.variants{j};
                cur_elem.SubType = subset_str;
                cur_construct.Element{end+1} = cur_elem;
                multiple_mutation_constructs{end+1} = cur_construct;
            end
        end
    case 'RandomDNA'
        mut_num = str2num(tokens{4});
        if mut_num > 4^mut_len
            error(['SynLibAddMultiMutation2Construct num random DNA variants: ' num2str(mut_num) ' is larger than possible mutation in bp len: ' num2str(mut_len)]);
        end
        
        mut_seqs = GenerateKRandomSeqs(mut_len, mut_num);
        
        for i=1:length(mut_seqs)
            
            cur_construct = basic_construct;

            cur_elem = multimut_element;
            cur_elem.Sequence = mut_seqs{i};
            cur_elem.SubType = [operation_str '_' num2str(i)];
            cur_construct.Element{end+1} = cur_elem;

            multiple_mutation_constructs{end+1} = cur_construct;
            
        end
        
    otherwise
        error(['SynLibAddMultiMutation2Construct unkown operation str:' operation_str]);
end







