function tab_struct = LoadTab2Struct(tab_file_name, no_header_flag, output_mat_file_name)
%function tab_struct = LoadTab2Struct(tab_file_name, no_header_flag, output_mat_file_name)


if ~exist('no_header_flag','var')
    no_header_flag = false;
end

if ~exist('output_mat_file_name','var')
    output_mat_file_name = '';
end


% count rows and columns
[row_number, col_number] = GetTabFileSize(tab_file_name);

raw = cell(row_number, col_number);


fid = fopen(tab_file_name,'r');

if fid < 0
    error(['File ' , tab_file_name ,' was not found.']);
end

disp_every_k_lines = max(100,ceil(row_number/1000)); 

line_index = 0;
while feof(fid)==0


    tline = fgetl(fid);

    if ~ischar(tline)
        break;
    end

    line_index = line_index + 1;

    if(mod(line_index,disp_every_k_lines) == 0)
        disp(['Parsing line:' num2str(line_index)]);
    end



    tokens = regexp(tline,'\t', 'split');
    tokens{end} = strtrim(tokens{end});

    raw(line_index,:) = tokens;
end

fclose(fid);




if no_header_flag
    
    tab_struct.prop = cell(1, size(raw,2));
    for p=1:size(raw,2)
        tab_struct.prop{p} = ['Col' num2str(p)];
    end
else
    tab_struct.prop = strrep(strtrim(raw(1,:)),' ', '_');
end

tab_struct.is_numeric = false(1,size(raw,2));

for p=1:size(raw,2)
    
    disp(['Converting column: ' num2str(p)]);
    

    if no_header_flag
        cur_data = raw(1:end,p);
    else
        cur_data = raw(2:end,p);
    end

    cur_is_numeric = 1;
    need_to_convert2num = false;

    for i=1:length(cur_data)
        if ~isnumeric(cur_data{i}) && ~isempty(cur_data{i})
            if (length(str2num(cur_data{i})) ~= 1 || ~isempty(strfind(cur_data{i},':'))) && ...
                    ~strcmp(upper(cur_data{i}),'NAN')
                cur_is_numeric = 0;
                break;
            else
                need_to_convert2num = 1;
            end
        end
    end
    
    % empty column is considered as string column
    if all(cellfun(@isempty,cur_data))
        cur_is_numeric = 0;
    end

    if cur_is_numeric
        cur_data_col = zeros(length(cur_data),1);
        for i=1:length(cur_data)
            if need_to_convert2num
                if isempty(cur_data{i})
                    cur_data_col(i) = NaN;
                elseif strcmp(upper(cur_data{i}),'NAN')
                    cur_data_col(i) = NaN;
                else
                    cur_data_col(i) = str2num(cur_data{i});
                end
            else
                cur_data_col(i) = cur_data{i};
            end
        end
        tab_struct.is_numeric(p) = true;
    else
        cur_data_col = cur_data;
    end

    cur_col_name = strrep(strrep(strrep(strrep(strrep(tab_struct.prop{p}, '(', '_'), ')', '_'), '-', 'm'), ':', '_'), ',', '_');
    tab_struct.(cur_col_name) = cur_data_col;

end


if ~isempty(output_mat_file_name)
    save(output_mat_file_name,'tab_struct','-v7.3');
end
    