function seq = GenerateRandomSeq(seq_len, alphabet, alphabet_P_val)
%function seq = GenerateRandomSeq(seq_len, alphabet, alphabet_P_val)


if ~exist('alphabet', 'var') || isempty(alphabet)
    alphabet = GetNtAlphabet();
end

if ~exist('alphabet_P_val', 'var') || isempty(alphabet_P_val)
    alphabet_P_val = [0.25 0.25 0.25 0.25];
end
alphabet_P_val = alphabet_P_val ./  sum(alphabet_P_val);
alphabet_P_val_cum = [0 cumsum(alphabet_P_val)];

alphabet = alphabet(:)';

alphabet_len = length(alphabet);


if isempty(seq_len) || seq_len < 1 || alphabet_len < 1
    seq = '';
    return
end

seq = repmat('N',1,seq_len);
if all(alphabet_P_val == [0.25 0.25 0.25 0.25])
    seq_num = randi(length(alphabet),1,seq_len);
    
    for i=1:alphabet_len
        seq(seq_num == i) = alphabet(i);
    end
else
    seq_num = rand(1,seq_len);
    for i=1:seq_len
        seq(i) = alphabet(sum(seq_num(i) > alphabet_P_val_cum));
    end
end
