function seqs = GenerateKRandomSeqs(seq_len, seqs_num,alphabet, alphabet_P_val)
%function seq = GenerateKRandomSeqs(seq_len, seqs_num,alphabet, alphabet_P_val)
% without repeats

if ~exist('alphabet', 'var') || isempty(alphabet)
    alphabet = GetNtAlphabet();
end

if ~exist('alphabet_P_val', 'var') || isempty(alphabet_P_val)
    alphabet_P_val = [0.25 0.25 0.25 0.25];
end
alphabet_P_val = alphabet_P_val ./  sum(alphabet_P_val);
alphabet_P_val_cum = [0 cumsum(alphabet_P_val)];

alphabet = alphabet(:)';

alphabet_len = length(alphabet);

if isempty(seq_len) || seq_len < 1 || alphabet_len < 1 || seqs_num <= 0
    seqs = {};
    return
end

num_optional_seqs = alphabet_len^seq_len;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% two options if many sequneces then generate all and select, else generate
% randomly
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

is_done = false;

if seqs_num <= sqrt(num_optional_seqs)
    
    seqs = cell(seqs_num,1);
    
    num_generated_seqs = 0;
    i=0;
    while num_generated_seqs < seqs_num &&i < 100 * seqs_num
        i=i+1;
        cur_seq = GenerateRandomSeq(seq_len, alphabet, alphabet_P_val);
        if ~ismember(cur_seq,seqs(1:num_generated_seqs))
            num_generated_seqs = num_generated_seqs+1;
            seqs{num_generated_seqs} = cur_seq;
        end
    end
    
    if num_generated_seqs == seqs_num
        is_done = true;
    end
end

if seqs_num == num_optional_seqs
    seqs = GenerateAllSeqs(seq_len,alphabet);
    is_done = true;
end

if ~is_done 
    seqs = cell(seqs_num,1);
    
    all_seqs = GenerateAllSeqs(seq_len,alphabet);
    % score seqs
    all_seqs_P = ones(size(all_seqs));
    for i=1:length(seqs_num)
        cur_seq = all_seqs{i};
        for j=1:length(cur_seq)
            all_seqs_P(i) = all_seqs_P(i) * alphabet_P_val(alphabet==cur_seq(j));
        end
    end

    all_seqs_P = all_seqs_P ./sum(all_seqs_P);
    all_seqs_P_cum = [0 ; cumsum(all_seqs_P)];

    for i=1:seqs_num
        cur_p = rand(1);
        cur_all_seqs_i = sum(cur_p>all_seqs_P_cum);
        seqs{i} = all_seqs{cur_all_seqs_i};
        all_seqs(cur_all_seqs_i) = [];
        all_seqs_P(cur_all_seqs_i) = [];
        all_seqs_P = all_seqs_P ./sum(all_seqs_P);
        all_seqs_P_cum = [0 ; cumsum(all_seqs_P)];
    end

end