function [all_seqs, all_seqs_int] = GenerateAllSeqs(seq_len, alphabet, out_mat_file)
%function [all_seqs, all_seqs_int] = GenerateAllSeqs(seq_len, alphabet)
% all_seqs_int - optional - the index of the sequence in the vector
%               for each sequence Seq2Int will give this index for a given
%               sequence

if ~exist('alphabet', 'var') || isempty(alphabet)
    alphabet = GetNtAlphabet();
end

alphabet = alphabet(:)';


alphabet_len = length(alphabet);

if isempty(seq_len) || seq_len < 1 || alphabet_len < 1
    all_seqs = {};
    return 
end

total_seq_num = alphabet_len^seq_len;
all_seqs = repmat('N',total_seq_num,seq_len);

for i=1:seq_len
    
    cur_rep_num = alphabet_len^(i-1);
    cur_char_rep = repmat(alphabet, cur_rep_num,1);
    cur_char_rep = cur_char_rep(:);
    cur_rep_len = length(cur_char_rep);
    
    all_seqs(:,i) = repmat(cur_char_rep, total_seq_num/cur_rep_len, 1);
    
end

all_seqs = cellstr(all_seqs);

if nargout > 1 || (exist('out_mat_file','var') && ~isempty(out_mat_file))
   all_seqs_int = nan(total_seq_num,1); 
   for i=1:length(all_seqs)
       all_seqs_int(i) = Seq2Int(all_seqs{i},alphabet);
   end
   
end

if exist('out_mat_file','var') && ~isempty(out_mat_file)
    save(out_mat_file, 'all_seqs', 'all_seqs_int');
end