function [MuN,EtaSq,F] = solveEvalMasterEquation(K, r, b, delta)
% [MuN,EtaSq,F] = SynLibKineticModelSolveEvalMasterEquation(K, r, b, delta)
% solves the master equation analytically, given K and r that can be computed using generate_Ks_mat.m
% if inputs are symbols returns equations for mean, noise^2 and fano
% if inputs are values returns values
% K is transition matrix
% r is vector of transcription rates
% b is average protein burst size (proteins per mRNA assuming geometric distribution)
% delta is protein degradation rate; delta = log(2)/t, if degradation/dilution
% is only due to cell division and t is the doubling time and log is the
% natural logarithm



% init
I = eye(length(K));
Knorm = [K; ones(1,size(K,2))];         % add row of ones to normalize
B = zeros(size(Knorm,1),1);
B(end) = 1;
R = diag(r);

% solve partial moments
M0 = Knorm \ B;                         % M0 is the zeroth partial moment of the mRNA abundance distribution
N1 = (K - delta*I) \ -(b*R*M0);         % N1 is the first partial moment of the protein abundance distribution

% get stats
MuN = (b*r*M0) / delta;                 % mean protein abundance
MuNSq = (1+b) * MuN + (b*r*N1)/delta;   % mean of protein abundance squared
SigmaSq = (MuNSq - MuN^2);              % variance

EtaSq = SigmaSq / MuN^2;                % noise
F = SigmaSq / MuN;                      % noise strength

