function [Ks_mat, r_vec] = generate_Ks_mat(kon, koff, ron, roff, bin_vec,dist_between_sites)
% function [Ks_mat, r_vec] = generate_Ks_mat(kon, koff, ron, roff, bin_vec,dist_between_sites)
% returns transition matrix (Ks_mat of size NxN) and transcription rate vector (r_vec of length N) given the transcription rate of the on state (kon), the transcription rate of the unbound state (roff) a promoter configuration vector (of length N) describing the presence of a binding site in each of N possible positions, and a vector (of length N) with the distances between the sites 

syms Ks_mat r_vec;

num_sites = sum(bin_vec);
sites_i = find(bin_vec);
num_states = 2^num_sites;

bin_mat = de2bi(0:(num_states-1));


r_vec = repmat(ron,1,num_states);
r_vec(1) = roff;


Ks_mat(1:num_states,1:num_states) = 0;


max_thresh_for_road_block = 15;
road_block_ratio = 1/1.75;

r2_r1_f = @(L) 1+tanh(L/(sqrt(2)*36));

for i1=1:size(bin_mat,1)
    
    vec1 = bin_mat(i1,:);
    
    for i2=1:size(bin_mat,1)
        
        if i1==i2
            continue;
        end
        
        vec2 = bin_mat(i2,:);
        
        if sum((vec1+vec2)==1) ~= 1
            Ks_mat(i2,i1) = 0;
        else
            changed_i = find(sum((vec1+vec2)==1));
            
            min_dist_on_left = 1000;
            min_dist_on_right = 1000;
            
            for ci=(changed_i-1):-1:1
                if vec1(ci) ==1
                    min_dist_on_left = (sites_i(changed_i)-sites_i(ci))*dist_between_sites;
                    break;
                end
            end
            for ci=(changed_i+1):1:num_sites
                if vec1(ci) ==1
                    min_dist_on_right = (sites_i(ci)-sites_i(changed_i))*dist_between_sites;
                    break;
                end
            end
            
            
            if vec1(changed_i) == 0 % binding
                
                % cal roadblock effect
                k_on_ratio_roadblock = 1;
                if min_dist_on_left <= max_thresh_for_road_block
                    k_on_ratio_roadblock = k_on_ratio_roadblock * road_block_ratio;
                end
                if min_dist_on_right <= max_thresh_for_road_block
                    k_on_ratio_roadblock = k_on_ratio_roadblock * road_block_ratio;
                end
                
                %cal near un-bound sites effect 
                k_on_near_sites_ratio = 1;
                
                for ci=(changed_i-1):-1:1
                    if vec1(ci) == 1
                        break
                    else
                         k_on_near_sites_ratio = k_on_near_sites_ratio * r2_r1_f((sites_i(changed_i)-sites_i(ci))*dist_between_sites)/2;
                    end
                end
                for ci=(changed_i+1):1:num_sites
                    
                    if vec1(ci) == 1
                        break
                    else
                         k_on_near_sites_ratio = k_on_near_sites_ratio * r2_r1_f((sites_i(ci)-sites_i(changed_i))*dist_between_sites)/2;
                    end
                end

                Ks_mat(i2,i1) = kon*k_on_near_sites_ratio*k_on_ratio_roadblock;

            else % un-binding
                
                % cal roadblock effect
                k_off_ratio = 1;
                if min_dist_on_left <= max_thresh_for_road_block
                    k_off_ratio = k_off_ratio * road_block_ratio;
                end
                if min_dist_on_right <= max_thresh_for_road_block
                    k_off_ratio = k_off_ratio * road_block_ratio;
                end
                
                
                Ks_mat(i2,i1) = koff*k_off_ratio;
                
                
                
            end
            
            
        end
        
    end
    
    
end


% filling the diagonal
for i1=1:size(bin_mat,1)
    i2=i1;
    
    Ks_mat(i2,i1) = -sum([Ks_mat(1:(i2-1),i1);Ks_mat((i2+1):end,i1)]);
    
    
end





