function [reads_frac_parsed,is_success_convert] = SynLibConvertBinFractionVec2SinglePeak(reads_frac,smooth_span,increase_cut_off)
% function [reads_frac_parsed,is_success_convert] = SynLibConvertBinFractionVec2SinglePeak(reads_frac,smooth_span,increase_cut_off)
% Filtering cells in expression bins outside the main peak
% reads_frac - fraction of cell in each bin
% smooth_span - the span used for smoothing the distribution for peak detection
% increase_cut_off - if fraction of cells between neighboring bins increase more than this ratio than then do not include the last bin in the peak
%
% reads_frac_parsed - cells distribution over expression bins in which bins outside the main peak were set to zero
% is_success_convert - the function successfully detected the peak


min_bin_frac = 1/(length(reads_frac)*10);


if ~exist('smooth_span','var') || isempty(smooth_span) || isnan(smooth_span)
    smooth_span = 3;
end

if ~exist('increase_cut_off','var') || isempty(increase_cut_off)
    increase_cut_off = 1;
end


reads_frac_parsed = zeros(size(reads_frac));
is_ok = false(size(reads_frac));
reads_frac_smooth = smooth(reads_frac,smooth_span);
[m, m_i] = local_SynLibConvertBinFractionVec2SinglePeak_findMaxUsingIntegral(reads_frac_smooth, min_bin_frac);

if (length(m_i) == 1 || ...
        all(diff(m_i) == 1)) && ...
        m >= min_bin_frac
    
    cur_m_min_i = min(m_i);
    cur_m_max_i = max(m_i);
    is_success_convert = true;
    is_ok(m_i) = true;
    
else
    reads_frac_parsed = nan(size(reads_frac_smooth));
    is_success_convert = false;
    return;
end


min_val = reads_frac_smooth(cur_m_min_i);
min_val_i = cur_m_min_i;
% left
for i=(cur_m_min_i-1):-1:1
    if reads_frac_smooth(i) <= reads_frac_smooth(i+1) && ...
       reads_frac_smooth(i) >= min_bin_frac;
        is_ok(i) = true;
        min_val = reads_frac_smooth(i);
        min_val_i = i;
    else
        if reads_frac_smooth(i) <= reads_frac_smooth(i+1)
            break;
        elseif reads_frac_smooth(i) >= min_val*increase_cut_off
            is_ok(i:(min_val_i-1)) = false;
            break;
        else
            is_ok(i) = true;
        end
        
    end
end


min_val = reads_frac_smooth(cur_m_max_i);
min_val_i = cur_m_max_i;
% right
for i=(cur_m_max_i+1):1:length(reads_frac_smooth)
    if reads_frac_smooth(i) <= reads_frac_smooth(i-1) && ...
            reads_frac_smooth(i)>= min_bin_frac;
        is_ok(i) = true;
        min_val = reads_frac_smooth(i);
        min_val_i = i;
    else
        
        if reads_frac_smooth(i) <= reads_frac_smooth(i-1)
            break;
        elseif reads_frac_smooth(i) >= min_val*increase_cut_off
            is_ok((min_val_i+1):i) = false;
            break;
        else
            is_ok(i) = true;
        end
    end
end

reads_frac_parsed(is_ok) = reads_frac(is_ok);
reads_frac_parsed = reads_frac_parsed ./ sum(reads_frac_parsed);

end

function [m, m_i] = local_SynLibConvertBinFractionVec2SinglePeak_findMaxUsingIntegral(reads_frac_smooth, min_bin_frac)


if all(reads_frac_smooth<min_bin_frac)
    [m, m_i] = max(reads_frac_smooth);
    m_i = m_i(1);
    return;
end

reads_frac_smooth(reads_frac_smooth<min_bin_frac) = 0;

in_reads_region = false;

reads_region_max = nan;
reads_region_max_i = nan;
reads_region_integral = nan;

reads_regions_vec_max = [];
reads_regions_vec_max_i = [];
reads_regions_vec_integral = [];

for i=1:length(reads_frac_smooth)
    
    cur_val = reads_frac_smooth(i);
    
    if cur_val>0
        
        if in_reads_region
            
            if reads_region_max<cur_val
                reads_region_max_i = i;
            end
            reads_region_max = max(reads_region_max,cur_val);
            reads_region_integral = reads_region_integral+cur_val;
        else
            in_reads_region = true;
            reads_region_max_i = i;
            reads_region_max = cur_val;
            reads_region_integral = cur_val;
        end
        
    else
        
        if in_reads_region
            reads_regions_vec_max(end+1) = reads_region_max;
            reads_regions_vec_max_i(end+1) = reads_region_max_i;
            reads_regions_vec_integral(end+1) = reads_region_integral;
            
            in_reads_region = false;
            reads_region_max_i = nan;
            reads_region_max = nan;
            reads_region_integral = nan;
            
        end
    end
    
    if i==length(reads_frac_smooth) && in_reads_region
        reads_regions_vec_max(end+1) = reads_region_max;
        reads_regions_vec_max_i(end+1) = reads_region_max_i;
        reads_regions_vec_integral(end+1) = reads_region_integral;
    end
end

[~, vec_m_i] = max(reads_regions_vec_integral + 0.0001 .* reads_regions_vec_max);

m = reads_regions_vec_max(vec_m_i(1));
m_i = reads_regions_vec_max_i(vec_m_i(1));

end