function [gamma_shape_param_a, gamma_scale_param_b,predicted_ranges_frac_vec] = 
FitGammaDistributionToValRangesProbabilities( ...
    ranges_edges, ranges_frac_vec, ...
    bin_means, bin_stds)
%function [gamma_shape_param_a, gamma_scale_param_b,predicted_ranges_frac_vec] = 
% FitGammaDistributionToValRangesProbabilities( ...
%    ranges_edges, ranges_frac_vec, ...
%    bin_means, bin_stds)
% ranges_edges - matrix - row for each range first column = min value edge,
% second cloumn - max value edge 
% gamma_shape_param_a, gamma_scale_param_b - fitted gamma function parameters
% predicted_ranges_frac_vec - vector of fractions of cells in each bin predicted by Gamma function 



dist_mean_estimate = sum(ranges_frac_vec .* bin_means);
dist_std_estimate = ComputeStdFromBinStdsAndMeans(bin_stds,bin_means,ranges_frac_vec;

lsqcurvefit_options = optimset('TolFun',10^(-12),'MaxFunEvals',10000,'MaxIter', 10000,'TolX', 10^(-12),'Display','off');


gam_a =  (dist_mean_estimate^2)/(dist_std_estimate^2);
gam_b =  (dist_std_estimate^2)/dist_mean_estimate;
x0 = [gam_a, gam_b];
gam_lb = x0 * 10^-2;
gam_ub = x0 * 10^2;
xdata = ranges_edges;
ydata = ranges_frac_vec;
[gam_param,resnorm,residual,exitflag,fit_output,lambda] = lsqcurvefit(@SynLibFitGammaDist2Regions,x0,xdata,ydata,gam_lb,gam_ub,lsqcurvefit_options);
gam_param_org = gam_param;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cum_dist_x = nan(1,size(ranges_edges,1)+1);
cum_dist_y = nan(1,size(ranges_edges,1)+1);

cum_dist_x(1) = ranges_edges(1,1);
cum_dist_y(1) = 0;
for r=1:size(ranges_edges,1)
    cum_dist_x(r+1) = ranges_edges(r,2);
    cum_dist_y(r+1) = cum_dist_y(r) + ranges_frac_vec(r);
end

%% kolmogorov-smirnov
f = @(x)SynLibFitGammaDist2RegionsByKS(x,cum_dist_x,cum_dist_y);

fmincon_options  = optimset( 'Algorithm','interior-point','Display','off'); %'Display','iter',
[gam_param] = fmincon(f,gam_param_org,[],[],[],[],gam_lb,gam_ub,[],fmincon_options);
gam_param_ks = gam_param;

% Kuiper's
g = @(x)SynLibFitGammaDist2RegionsByKuipers(x,cum_dist_x,cum_dist_y);
fmincon_options  = optimset('Algorithm','interior-point','Display','off'); % Kuipers
[gam_param] = fmincon(g,gam_param_ks,[],[],[],[],gam_lb,gam_ub,[],fmincon_options);
gam_param_kuip = gam_param;

% L2 fit - using Kuipers as a starting point
[gam_param,resnorm,residual,exitflag,fit_output,lambda] = 
lsqcurvefit(@SynLibFitGammaDist2Regions,gam_param_kuip,xdata,ydata,gam_lb,gam_ub,lsqcurvefit_options);
gam_param_byBin2 = gam_param;


% Trying all methods using other methods results as a starting point
scores_mat = [sum((SynLibFitGammaDist2Regions(gam_param_org,xdata)-ydata).^2) ...
    sum((SynLibFitGammaDist2Regions(gam_param_ks,xdata)-ydata).^2) ...
    sum((SynLibFitGammaDist2Regions(gam_param_kuip,xdata)-ydata).^2) ...
    sum((SynLibFitGammaDist2Regions(gam_param_byBin2,xdata)-ydata).^2); ...
    SynLibFitGammaDist2RegionsByKS(gam_param_org,cum_dist_x,cum_dist_y), ...
    SynLibFitGammaDist2RegionsByKS(gam_param_ks,cum_dist_x,cum_dist_y), ...
    SynLibFitGammaDist2RegionsByKS(gam_param_kuip,cum_dist_x,cum_dist_y), ...
    SynLibFitGammaDist2RegionsByKS(gam_param_byBin2,cum_dist_x,cum_dist_y); ...
    SynLibFitGammaDist2RegionsByKuipers(gam_param_org,cum_dist_x,cum_dist_y), ...
    SynLibFitGammaDist2RegionsByKuipers(gam_param_ks,cum_dist_x,cum_dist_y), ...
    SynLibFitGammaDist2RegionsByKuipers(gam_param_kuip,cum_dist_x,cum_dist_y), ...
    SynLibFitGammaDist2RegionsByKuipers(gam_param_byBin2,cum_dist_x,cum_dist_y)];


% selecting the best fit
scores_mat_r = nan(size(scores_mat));

for i=1:size(scores_mat,1)
    [~, tmp_inds] = sort(scores_mat(i,:));
    for j=1:size(scores_mat,2)
        scores_mat_r(i,tmp_inds(j)) = j;
    end
end

if sum(sum(scores_mat_r)==min(sum(scores_mat_r))) > 1
    scores_mat_r = nan(size(scores_mat));
    
    for i=1:size(scores_mat,1)
        [~, tmp_inds] = sort(scores_mat(i,:));
        for j=1:size(scores_mat,2)
            if i==1
                scores_mat_r(i,tmp_inds(j)) = j*2;
            else
                scores_mat_r(i,tmp_inds(j)) = j;
            end
        end
    end
end
    

 [~,m_i] = nanmin(sum(scores_mat_r));
 switch m_i
     case 1
         gam_param = gam_param_org;
     case 2
         gam_param = gam_param_ks;
     case 3
         gam_param = gam_param_kuip;
     case 4
         gam_param = gam_param_byBin2;
 end
          


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

gamma_shape_param_a = gam_param(1);
gamma_scale_param_b = gam_param(2);


predicted_ranges_frac_vec = SynLibFitGammaDist2Regions(gam_param,xdata);