function all_std = ComputeStdFromBinStdsAndMeans(bins_std,bins_mean,bins_prob)
%function all_std = ComputeStdFromBinStdsAndMeans(bins_std,bins_mean,bins_prob)

all_std = NaN;

if length(bins_std) ~= length(bins_mean) || ...
        length(bins_std) ~= length(bins_prob)
    error('ComputeStdFromBinStdsAndMeans lengths of vectors are not equal');
end

bins_var = bins_std .^ 2;
bins_prob = bins_prob / sum(bins_prob);

all_mean = sum(bins_mean.*bins_prob);

all_var = 0;

for i=1:length(bins_std)
    all_var = all_var + bins_prob(i)*(bins_var(i)+(bins_mean(i)-all_mean).^2);
end

all_std = sqrt(all_var);






