% This script computes the average nucleosome occupancy in the interval
% [TSS-1000, TSS+1000]

% Load the sample occupancy profile (cell array; each cell corresponds to a chromosome)
load('Sample_Profile.mat', 'Occupancy')

% Set the interval of interest around TSS
beforeTSS = 1000;   % 1000 bp upstream TSS
afterTSS  = 1000;   % 1000 bp downstream TSS

% Compute the average nucleosome occupancy in this interval
AverageProfile = Compute_Average_TSS_Distribution(Occupancy, beforeTSS, afterTSS);
% NOTE: The same function can be used to compute the average dyad
% distribution near TSS

% Plot the normalized profile
figure
plot(-beforeTSS : afterTSS, AverageProfile, 'LineWidth', 3)
set(gca, 'FontSize', 14, 'XTick', [-1000:500:1000]);
xlim([-1000, 1000])
xlabel('Position relative to TSS (bp)', 'FontSize', 16);
ylabel({'Average occupancy'; '(# of paired-end reads)'}, 'FontSize', 16);
set(gca, 'XGrid','on')