function AverageProfile = Compute_Average_TSS_Distribution(Profile, beforeTSS, afterTSS)

% Load annotations
load('Yeast_Annotations.mat', 'ORF', 'TSS', 'Watson', 'Chr', 'chrLen')

noGenes = numel(ORF);
AlignedProfiles = nan(noGenes, 1 + beforeTSS + afterTSS);
for g = 1:noGenes
    if Watson(g)
        % Select the interval around TSS
        leftEdge = max([TSS(g) - beforeTSS, 1]);
        rightEdge = min([TSS(g) + afterTSS, chrLen(Chr(g))]);
        % Align this interval with the previous ones
        AlignedProfiles(g, beforeTSS + 1 - (TSS(g) - leftEdge)...
            : beforeTSS + 1 + (rightEdge - TSS(g))) = ...
            Profile{1,Chr(g)}(leftEdge : rightEdge);
    else % if Watson(g) == false
        % Select the window around TSS
        leftEdge = max([TSS(g) - afterTSS, 1]);
        rightEdge = min([TSS(g) + beforeTSS, chrLen(Chr(g))]);
        % Align this interval with the previous ones
        AlignedProfiles(g, beforeTSS + 1 - (rightEdge - TSS(g))...
            : beforeTSS + 1 + (TSS(g) - leftEdge)) = ...
            fliplr(Profile{1,Chr(g)}(leftEdge : rightEdge)); % flip the gene from Crick strand
    end
end

AverageProfile = nanmean(AlignedProfiles); % Compute the mean neglecting the NaNs