import os
import glob
from leo.common import cl
import scipy as SP
import pylab as PL
from gfpvar.tools.common import *


def get_coverages(af_file):
    d = cl(af_file)
    covs = []
    for c in d:
        covs.extend(d[c][5])
    return covs


def print_all_covs():
    for f in glob.glob("%s/seq/Sample?_*/3_af/*.pickle"%DATA_DIR):
        s = f.split("/")[-3]
        print s, SP.median(get_coverages(f))
        

def print_file_coverage_stats(pileup_file):
    covs = SP.array([l.split()[7] for l in file(pileup_file, 'r')], int)
    print "%d\t%d\t%d\t%s"%(SP.median(covs), covs.mean(), covs.var()**0.5, pileup_file.split('/')[-1])
    return SP.median(covs), covs.var()**0.5, pileup_file.count("Plate") > 0


def print_coverage_stats():
    d = []
    for f in glob.glob("%s/seq/Sample4_*/2_pileup/*.pileup"%DATA_DIR):
        if f.count("SSA") == 0:
            d.append(print_file_coverage_stats(f))

    d = SP.array(d, int)
    cols = 'br'
    for i in range(2):
        I = SP.where(d[:,2] == i)[0]
        PL.plot(d[I,0], d[I,1], cols[i] + ".", markersize=12, alpha=0.5)
    PL.savefig("coverages.pdf")


def main():
    print_all_covs()
    #    print_coverage_stats()
    pass


if __name__ == '__main__':
    main()
