from gfpvar.tools.common import *
from gfpvar.tools.io import *
from leo.common import *
import scipy as SP
import pylab as PL
import glob
import os
import sys


def plot(chrm, sample_data, samples):
    cols = 'bgrc'
    init = [d[chrm][0] for d in sample_data]
    post = [d[chrm][1] for d in sample_data]
    locs = [d[chrm][4] for d in sample_data]

    PL.figure(figsize=(15,10))
    for i in range(3):#len(init)):
        PL.subplot(3,1,i+1)
        I = SP.where(abs(init[i] - 0.5) < 0.45)[0]
        PL.plot(locs[i][I], init[i][I], ".", markersize=7, alpha=0.2, color=cols[i])
        PL.plot(locs[i], post[i], markersize=7, alpha=1, color=cols[i], lw=4)
        PL.plot([min(locs[i]), max(locs[i])], [0,0], 'k-')
        PL.plot([min(locs[i]), max(locs[i])], [1,1], 'k-')
        PL.title(samples[i])
        PL.ylim(-0.1,1.1)
        #        PL.xlim(530000,830000)
    if 0:
        PL.subplot(5,1,5)
        for i in range(len(init)):
            PL.plot(locs[i], post[i], markersize=7, alpha=0.2, color=cols[i])
        PL.ylim(-0.1,1.1)
        PL.title("Combined smoothed")    
    PL.suptitle(get_seq_chr_names()[chrm])


def plot_chrs():
    files = glob.glob("%s/seq/*/3_af/*_af.pickle"%(DATA_DIR))
    samples = [f.split("/")[-3] for f in files]
    all_data = [cl(f) for f in files]
    for chrm in all_data[0]:
        if chrm != "ref|NC_001143|": continue
        plot(chrm, all_data, samples)
        
    PL.show()


def main():
    plot_chrs()

if __name__ == '__main__':
    main()
