from gfpvar.tools.common import *
import glob
import os


def main():
#    for f in glob.glob("%s/seq/*/2_pileup/*.pileup"%DATA_DIR):
#        read_pileup(f.split("/")[-3], 10, 10)
#    return

    sites_file = "%s/seq/sites/all_sites.bcf"%DATA_DIR
    ref_file = "%s/seq/ref/S288c-ref.fasta"%DATA_DIR
    BAMFILE_PATTERN = "%s/seq/Sample4*/1_align/*.bam"%DATA_DIR

    for f in glob.glob(BAMFILE_PATTERN): # for each alignment .bam file
        sample = f.split("/")[-3] 
        lane = f.split("_")[-3].split("-")[1] #align_lane-L001_Sample3_33.bam
        outfile_pileup = "%s/seq/%s/2_pileup/%s_%s.pileup"%(DATA_DIR,sample,sample,lane)
        if os.path.exists(outfile_pileup): continue
        cmd = "~/bin/samtools pileup -vcs -N 2 -l %s -f %s %s > %s\n"%(sites_file, ref_file, f, outfile_pileup) # create pileup command

        scriptfile = "%s/seq/%s/2_pileup/call_sites_with_pileup_%s.sh"%(DATA_DIR, sample,lane)
        ofh = file(scriptfile, 'w') # create a script file
        ofh.write(cmd)
        ofh.close()
        os.system("submitjob sh %s"%(scriptfile)) # and run it


if __name__ == '__main__':
    main()
