import sys
from gfpvar.analysis.array.qtl import *


def main():
    # difference threshold of 0.2 - under assumptions that (log10(BY +) - log10(RM +)) - (log10(BY - ) - log10(RM -)) can be transformed as follows:
    # p/(1-p) = 10**0.2 => p ~ 0.62 => p - (1-p) ~ 0.25. So signal difference around 0 of 0.2 is roughly 25% allele frequency difference.
    # At higher intensities this is obviously no longer true, but this serves as a rough guide.
    if len(sys.argv) > 1:
        datasets = sys.argv[1:]
    else:
        datasets = ["2013-02-22_round1", "2013-03-06_round1-rehyb", "2013-03-07_round1-hyb3-1", "2013-03-07_round1-hyb3-2", "2013-03-07_round1-hyb3-3"]

    for dataset in datasets:
        create_qtls(dataset=dataset, sample_pattern="_plus", diff_threshold=0.2, length_threshold=30000, save_signal=True)
    return

if __name__ == '__main__':
    main()
