import pdb
import scipy as SP
import pylab as PL
from gfpvar.tools.common import *
from gfpvar.analysis.img.quantify import *
from gfpvar.analysis.img.util import *


def quantify(screen, rerun=False):
    res = None
    if rerun: # if requantify, 
        basedir = "%s/img"%DATA_DIR
        data, meta, data_features, meta_features = read_combined_cp_matrix(screen, trainingset=None) # read combined data
        res = quantify_gfp(data, data_features, meta, min_well_cells=10) # and quantify
        cdm(res, "img_quant_%s.pickle"%screen) # 
    else:
        res = cl("img_quant_%s.pickle"%screen)

    d, wells = res_to_mat(res) # Create a matrix version of the results
    #debug_features(d)        
    compare_img_cyto(d, wells) # and plot comparisons
    

def main():
    quantify("all-h2")


if __name__ == '__main__':
    main()
