from leo.common_plot import *
import scipy as SP
from leo.common import *
from gfpvar.tools.util import *
import pylab as PL


def contrast():
    di = cl("%s/img/combined/gfp_median.pickle"%DATA_DIR)
    ms,vars = [], []
    for (p, row, c) in di:
        vars.append(SP.log10(di[p,row,c]).var())
        ms.append(SP.log10(SP.median(di[p,row,c])))
        
    PL.plot(ms, vars, ".", markersize=10, alpha=0.4)
    PL.xlabel("mean")
    PL.ylabel("var")
    PL.show()


def compare(var=False):
    di = cl("%s/img/combined/gfp_median.pickle"%DATA_DIR)
    dc = cl("%s/cytometry/Pilot_screen_BYxRM/plate_stats/combined/mixture-dict-all_haploid-R3.pickle"%DATA_DIR)
    get_screen_well(dc['wells'][0])
    wells = dc['wells']
    gfp_c = dc['gfp_means'][:,0]
    gfp_v = dc['gfp_vars'][:,0]
    common = []
    for i in range(len(wells)):
        p,r,c = get_screen_well(wells[i])
        row = ord(r) - ord('A') + 1
        if (p, row, c) in di:
            if var:
                common.append((SP.log10(di[p,row,c]).var(), gfp_v[i]))
            else:
                #                if SP.log10(di[p,row,c]).var() < 0.1:
                    common.append((SP.log10(SP.median(di[p,row,c])), gfp_c[i]))
        
    common = SP.array(common)
    PL.plot(common[:,0], common[:,1], ".", markersize=10, alpha=0.4)
    PL.xlabel("img")
    PL.ylabel("cyto")
    PL.show()


def main():
    compare(False)
    compare(True)
    contrast()


if __name__ == '__main__':
    main()
