import glob
import os
import sys
from gfpvar.tools.common import *
from gfpvar.analysis.img.cp_io import *

def combine(dir, outfile, experiment, screen, plate):
    LOG.debug("Combining %s %s %s %s %s"%( dir, outfile, experiment, screen, plate))
    combine_cp_batches(dir, outfile, experiment, screen, plate)


def combine_all(pipeline="pilot_base_smoothfirst", experiment="test_exp", overwrite=False):
    basedir = "%s/img"%DATA_DIR
    LOG.debug("Combining all screens for experiment %s, pipeline %s"%(experiment, pipeline))

    for screendir in glob.glob("%s/cp_output/%s/%s/*"%(basedir, pipeline, experiment)):
        screen = screendir.split("/")[-1]
        outdir = "%s/combined/%s/%s/%s"%(basedir, pipeline, experiment, screen)
        if not os.path.exists(outdir): os.system("mkdir -p %s"%outdir)

        for platedir in glob.glob("%s/*_*"%screendir):
            plate = platedir.split("_")[-1]
            outfilename = "%s/plate_%s.tab"%(outdir, plate)
            
            if HOSTNAME == "can1.local":
                combine(platedir, outfilename, experiment, screen, plate)
            else:
                if os.path.exists(outfilename) and (not overwrite): continue
                shfilename = "tmp_%s_%s_%s.sh"%(pipeline, screen, plate)
                ofh = file(shfilename, 'w')
                ofh.write('source /home/morphology/shared/lparts/.bashrc_leopold; python run_1_combine_cp.py %s %s %s %s %s'%(platedir, outfilename, experiment, screen, plate))
                # ofh.write("; rm %s"%shfilename)
                ofh.close()
                LOG.debug("Submitting job to combine plate %s from screen %s experiment %s"%(plate, screen, experiment))
                os.system("submitjob sh %s"%shfilename)


def main():
    if len(sys.argv) > 1:
        if sys.argv[1] == "all":
            pipeline = "pilot_base_smoothfirst"
            if len(sys.argv) > 3: pipeline = sys.argv[3]
            combine_all(experiment=sys.argv[2], pipeline=pipeline)
            return
        elif sys.argv[1] == "test":
            combine_all()
            return
        else:
            combine(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5])        
            return


    experiment = "Pilot_screen_BYxRM"
    screen = "all-h2"
    basedir = "%s/img"%DATA_DIR
    cpdir = "%s/cp_output/%s/%s"%(basedir, experiment, screen)
    combined_dir = "%s/combined/%s/%s"%(basedir, experiment, screen)
    plate = "all-h2-Haploid-R1"
    combine_cp_batches(cpdir, "%s/combined_thin.tab"%combined_dir, experiment, screen, plate)


if __name__ == "__main__":
    main()
