import os
from gfpvar.tools.common import *
from gfpvar.analysis.cyto.quantify import *
from gfpvar.analysis.cyto.h2 import *

""" Read the combinations of screens and plates to output as tab files
@return list of individual combinations. Each item of the list is a tuple (name, [screen1,screen2,..], ploidy) """
def get_screen_combos():
    result = []
    ifh = file("%s/summary/cyto/screen_combinations.txt"%DATA_DIR, "r")
    for l in ifh:
        d = l.strip().split("\t")
        if l[0] != "#": result.append((d[0], d[1].split(","), d[2]))
    return result


""" Create a single tab file for the relevant plates
@param name name of summary set to be used in output file name
@param screens list of screens to use
@param ploidy ploidy to match (in "Haploid","Diploid")
"""
def create_tabs(name, screens, ploidy, experiment="Pilot_screen_BYxRM", overwrite=True):
    outfilename = "%s/summary/cyto/%s/%s.tab"%(DATA_DIR, experiment, name)
    if (not overwrite) and os.path.exists(outfilename):
        return
    create_combined_mat(screens=screens, outfilename=outfilename, allowed_ploidies=[ploidy])


def main():
    experiment = "Pilot_screen_BYxRM"
    for screen in get_screen_combos():
        create_tabs(*screen)
        infilename = "%s/summary/cyto/%s/%s.tab"%(DATA_DIR, experiment, screen[0])
        outfilename = infilename.replace(".tab", "-h2-200-0.7.tab")
        #output_h2_tab(outfilename, infilename, min_cells_slice=200, max_gfp_var=0.7)



if __name__ == '__main__':
    main()
