import sys
from gfpvar.analysis.cyto.plot import *
from gfpvar.tools.common import *


def plot_all_candidates(candidate_file):
    for line in file(candidate_file, 'r'):
        if line[0] == "#": continue
        orf = line.split()[0]
        #plot_candidate_replicas(orf, outfilename="%s/plots/candidate/reps_%s.pdf"%(DATA_DIR, orf),screens=["haploid-R1", "haploid-R3", "reciprocal_candidate"],debug=True, threshold=0.9)
        plot_candidate_summaries(orf, outfilename="%s/plots/candidate/sum_%s.pdf"%(DATA_DIR, orf), screens=["haploid-R1", "haploid-R3", "reciprocal_candidate", "interesting_candidate"])


def main():
    candidate_file = "%s/candidates/2012-10-23_sort-round3-genes_plateloc.tab"%DATA_DIR

    if len(sys.argv) > 1:
        candidate_file = sys.argv[1]

    plot_all_candidates(candidate_file)
    


if __name__ == '__main__':
    main()
