from gfpvar.tools.common import *
from gfpvar.analysis.cyto.quantify import process_screen
from gfpvar.analysis.cyto.cluster import cClusteringSettings
import glob
import time
import pylab as PL

"""
To reproduce paper data:
1. Pick which screens. Clean data used haploid-R1, haploid-R3, haploid-R6, haploid-fillin
2. Pick cluster settings. All screens were scored with fscasclicesize 0.1, 48 rndfiles, 20 restarts, 0.8 clustering threshold, 100000 training data points
n_rfp_modes=2 for all screens but haploid-R1, and 1 for haploid-R1 (BY and RM wells separate).
Some screens were scored with preset prior (long stretch with no change in cytometer settings). The defaults are as specified in fcs.py
The rest of the screens were scored using a manual gating, as laser intensities etc changed, and old settings could not be used.
The gates are in the clustering pickle file ('filters':['FSC-A', 4.8, 5.4] etc).
"""
def main():
    LOG.setLevel(logging.INFO)
    screens = ["haploid-R1", "haploid-R2", "haploid-R3", "fillin"]
    plate_pattern = "*R2"
    screens = ["gfpswaps"]
    plate_pattern = "*_R?"
    
    for screen in screens:
        cluster_settings = cClusteringSettings(prior="manual", n_restarts=20, points=100000, threshold=0.80, fscasclicesize=0.10, n_rfp_modes=2-(screen=="haploid-R1"))
	process_screen(screen, cluster_settings, overwrite=True, overwrite_cluster=False, plate_pattern=plate_pattern)

	
if __name__ == '__main__':
    main()
