import scipy as SP
import pdb

COMBS = SP.array([[1,1,0,0],[1,0,1,0],[0,1,1,0],[1,0,0,1],[0,1,0,1],[0,0,1,1]],int)
POW24 = SP.array([2**i for i in range(4)])

def generate_phenos(n_loci):
    p = SP.zeros([2**n_loci,2**(2**n_loci)])
    for i in range(2**(2**n_loci)):
        for j in range(2**n_loci):
            p[j,i] = ((i/(2**j))%2)
    return p


def generate_tetrads(n_loci):
    tet = SP.zeros([6**(n_loci-1),n_loci], int)
    tet[:,0] = 0 # fix his

    for i in range(1, n_loci): # for other two loci
        for c in range(6**(n_loci-1)):
            l = (c / 216 > 0) + (c / 36 > 0) + (c / 6 > 0) # assume n_loci <= 4
            tet[c, i] = c%6 # store combination index
    return tet


def nicegeno(geno, n_loci):
    res = ""
    for i in range(n_loci-1):
        alleles = [chr(ord('A') + i),chr(ord('a') + i)]
        res = res + "".join([alleles[COMBS[geno[i+1],j]] for j in range(4)]) + " "
    return res


def niceconf(conf, n_loci):
    res = ""
    for i in range(len(conf)):
        for j in range(n_loci):
            res += "01"[i/(2**j) % 2]
        res += "-%d"%conf[i]
        res += " "
    return res


def main():
    n_loci = 2
    pun = generate_phenos(n_loci)
    configs = generate_tetrads(n_loci)
    pow2 = SP.array([2**i for i in range(n_loci)], int)
    req_survivors = [[[1,1,0,0]] , [[1,0,1,0],[1,0,0,1],[0,1,1,0],[0,1,0,1]], [[0,0,1,1]], [[0,0,1,0],[0,0,0,1]], [[1,0,0,0],[0,1,0,0]] ] # list of lists of configurations. Each sublist must have at least one survivor
    req_die = [[1,1,1,0],[1,1,0,1],[1,0,1,1],[0,1,1,1],[1,1,1,1]] # cannot have > 2 live

    for p in range(pun.shape[1]): # for each phenotype configuration
        result = SP.zeros([16]*n_loci + [4], bool)
        for c in range(configs.shape[0]): # for each tetrad configuration
            r = pun[SP.dot(pow2, COMBS[configs[c]]),p] # calculate whether each segregant lives or not
            result[tuple(SP.dot(COMBS[configs[c]], POW24))] = r # store result for this segregant combination
        all_exist = SP.zeros(len(req_survivors), bool)
        for i,r in enumerate(req_survivors): # each of the required survivors list must have a tetrad configuration under which it survived
            for subr in r: all_exist[i] = all_exist[i] or (~SP.logical_xor(result, subr).any(axis=-1)).any() # it's an or across all sublists
        all_die = SP.zeros(len(req_die),bool)
        for i,r in enumerate(req_die):
            all_die[i] = not ((~SP.logical_xor(result, r)).all(axis=-1)).any() # if any configuration has same survival pattern (xor all 0), no good match
        print p, "\t", all_exist.all(), all_die.all(), "\t", all_exist, "\t", all_die
        if all_exist.all() and all_die.all():
            print niceconf(pun[:,p], n_loci)
            
    pdb.set_trace()
    pass

if __name__ == '__main__': main()

