import scipy as SP
from parts2014_gfpvar.tools.common import *


def read_mrna_cis_linkages():
    infilename = "%s/mrna/local_glucose_peaks.tab"%DATA_DIR
    d = SP.array([l.split("\t")[0:19] for l in file(infilename, 'r').readlines()[1:]])
    lods = SP.array(d[:,6], float)
    effect_sizes = SP.array(d[:,17:19], float)
    return d, lods, effect_sizes


def read_mrna_trans_linkages(orf=None):
    infilename = "%s/mrna/smith_linkage_trans.tab"%DATA_DIR
    d = SP.array([l.strip().split("\t") for l in file(infilename, 'r').readlines()[1:]])
    lods = SP.array(d[:,6], float)
    peaks = d[:,9]
    I = range(len(d))
    if orf is not None:
        I = SP.where(d[:,0] == orf)[0]
    return d[I], lods[I], peaks[I]

