import scipy as SP
import glob
from parts2014_gfpvar.tools.common import *

def read_image_name(filename):
    res = {}
    ifh = file(filename, 'r')
    ifh.next() # header
    for l in ifh:
        d = l.strip().split(",")
        res[d[34]] = d[29] # number to name map
    return res


def read_rfp_features(filename):
    res = []
    ifh = file(filename, 'r')
    ifh.next()
    for l in ifh:
        d = l.strip().split(",")
        res.append([d[0],d[1],d[2],d[26],d[27],d[19]]) # img, obj, area, x,y, RFP
    return SP.array(res)


def read_gfp_features(filename):
    res = {}
    ifh = file(filename, 'r')
    ifh.next()
    for l in ifh:
        d = l.strip().split(",")
        res[d[0] + "_" + d[1]] = [d[2],d[10],d[6], d[11], d[19]] # img, obj => area, perimeter, form factor, solidity, GFP
    return res


def get_well(filename):
    fn = filename.split("/")[-1]
    row, column, site = int(fn[0:3]), int(fn[3:6]), int(fn[6:9])
    return row, column, site


def combine(max_cells_image=125):
    ofh = file("combined.tab", "w")
    ofh.write("#Image\tRow\tCol\tSite\tObject\tRFP_area\tRFP_X\tRFP_Y\tRFP_intensity\tCell_area\tCell_perimeter\tCell_FormFactor\tCell_Solidity\tGFP_intensity\n")
    for filename in glob.glob("pic*Image.csv"): 
        img = read_image_name(filename)
        rfp = read_rfp_features(filename.replace("Image", "1_Nuclei"))
        gfp = read_gfp_features(filename.replace("Image", "2_CellsFromNuclei"))
        for i in img:
            row, col, site = get_well(img[i])
            I = SP.where(rfp[:,0] == i)[0]
            if len(I) > max_cells_image: continue
            for c in I:
                a,p,ff,so, g = gfp["%s_%s"%(i,rfp[c,1])]
                ofh.write("%s\t%d\t%d\t%d\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n"%(img[i], row,col,site, rfp[c,1], rfp[c,2], rfp[c,3], rfp[c,4], rfp[c,5], a,p,ff,so,g))
    ofh.close()


if __name__ == '__main__':
    combine()
