import pylab as PL
import scipy as SP
import pdb
from parts2014_gfpvar.tools.common import *

""" """
def plot_triangle(min_pairs=20):
    d = SP.loadtxt("%s/paper/table_S2-img.tab"%DATA_DIR, delimiter="\t", dtype=object, comments="$")
    i_parentkid, i_clone, i_total = [8,17], 10, [10,19,21]
    i_nparentkid, i_nclone, i_ntotal = [9,18], 11, [11,20,22]
    print d[0][i_parentkid], d[0][i_clone], d[0][i_total]
    parental, clonal, total = SP.array(d[1:,i_parentkid], float).mean(axis=1), SP.array(d[1:,i_clone], float), SP.array(d[1:,i_total], float).max(axis=1)
    n_parental, n_clonal, n_total = SP.array(d[1:,i_nparentkid], float).min(axis=1), SP.array(d[1:,i_nclone], float), SP.array(d[1:,i_ntotal], float).min(axis=1)
    I = SP.where((n_parental >= min_pairs) & (n_clonal >= min_pairs) & (n_total >= min_pairs))[0]
    #parental, clonal, total = parental[I], clonal[I], total[I]
    
    n1,n2,n3, n = sum(parental <= clonal), sum(parental <= total), sum(clonal <= total), len(parental)
    print "%d of %d (%.1f%%) parent-kid variance smaller than clone, %d of %d (%.1f%%) parent-kid smaller than total, %d of %d (%.1f%%) clonal smaller than total"%(n1, n, 100*n1/n, n2, n, 100*n2/n, n3, n, 100*n3/n)
    
    # Calculate variance decomposition from raw variance values
    vals = SP.array([parental,clonal-parental,total-clonal]).T # The columns should correspond to the variance components.
    vals[SP.where(vals[:,1] < 0)[0],1] = 0 # However, in reality, sometimes parental can be larger than clonal. We cannot deal with it, so set it to 0.
    vals[SP.where(vals[:,2] < 0)[0],2] = 0 # Same for difference between total and clonal variance.
    vals = (vals.T/(vals.sum(axis=1))).T # this normalises the rows to add up to 1.

    # Have the contributions to variance, now calculate coordinates in the triangle
    a, y = 1./(3**0.5), vals[:,0]
    x = (y + 2*vals[:,1])*a 

    # Now have everything - on to plot.
    PL.figure(None,[6,5])
    # 0. Dots for the decomposition
    PL.plot(x, y, ".", alpha=0.05, markersize=15)
    #I = SP.where(z1 < 0.8)[0]
    #PL.plot(x[I], y[I], "b.", alpha=0.1, markersize=12)
    # 1. Sides of the triangle
    PL.plot([0,2*a],[0,0], "k-")
    PL.plot([0,a],[0,1], "k-")
    PL.plot([2*a,a],[0,1], "k-")
    # 2. Names of the vertices
    PL.text(-0.15,-0.05,"Genotype")
    PL.text(2*a-0.1,-0.05,"Clone-to-clone")
    PL.text(a-0.15,1.05,"Mother-daughter")
    PL.xticks(());PL.yticks(())
    PL.xlim(-0.3,2*a+0.3); PL.ylim(-0.1,1.1)
    # 3. Save and show
    #PL.savefig("%s/paper/figure_S5.svg"%DATA_DIR)
    PL.savefig("%s/paper/figure_S5.pdf"%DATA_DIR, dpi=300)
    #PL.savefig("%s/paper/figure_S5.png"%DATA_DIR, dpi=300)
