import os
import time
import sys
import glob
sys.path.append("../../") # do this instead of the next import not to depend on any user-specific paths
#from gfpvar.tools.common import *


def main():
    jobid, img_dir = sys.argv[1:3]
    lines = file("/home/morphology/shared/lparts/pbs-output/cp.%s"%jobid, "r").readlines()
    error_index = [i for i in range(len(lines)) if lines[i].count("ERROR:") > 0][0]
    image_index = int(lines[error_index-1].split("#")[1].strip().split(",")[0])
    well_index = 1
    n_row_imagefiles = len(glob.glob("%s/*.tif"%img_dir))
    if len(glob.glob("%s/*1.tif"%img_dir)) != len(glob.glob("%s/*.tif"%img_dir)): # if some images do end in "1.tif", then one image per site, not per well
        well_index = ((image_index - 1) % 4) + 1
    else: # else all 24 x 4 images are assumed sequential - there are really 4 per file, so need to get rid of the entire file
        image_index = (image_index - 1)/4 + 1
        
    row = img_dir.split("-")[-1]
    todelete = "%s/0%s%03d%03d.tif"%(img_dir, row, image_index, well_index)
    LOG.debug("Based on line %s, think image %d well %d is somehow off. Removing %s"%(lines[error_index - 1], image_index, well_index, todelete))
    os.system("rm %s"%todelete)


if __name__ == '__main__':
    main()
