import pylab as PL
import scipy as SP
d = SP.array([map(float, l.strip().split()) for l in file('allcals','r')])
d[:,4] = d[:,4]**0.5
d[:,3] = d[:,3]**0.5
d2  = d.T/d[:,2]
PL.rcParams.update({'text.fontsize':40, 'xtick.labelsize':24, 'ytick.labelsize':24, 'text.size':40, 'axes.titlesize':30, 'axes.labelsize':26, 'figure.figsize':(16,10), 'legend.fontsize':24})

for i in range(d2.shape[1]):
    PL.bar([i], d2[2:3,i], color="r")
    PL.bar([i], d2[1:2,i], color="y")
    PL.bar([i], d2[0:1,i], color="b")
    
PL.ylabel("Fraction of total GFP variance")
PL.xlabel("Six of most heritable GFP strains")
PL.xticks(())
PL.legend(["Segregating population", "One clone","Mother-daughter"], loc="upper left")
PL.show()
