\name{single.locus.bootstrap}
\alias{single.locus.bootstrap}

\title{
Run the likelihood based model selection with bootstrapping.
}
\description{
Run the likelihood based model selection with bootstrapping.
}
\usage{
single.locus.bootstrap(genes, models, data, q.cols, fname, n.bootstrap, redo = T, covar = NULL)
}

\arguments{
  \item{genes}{ list of gene names for which to run the model selection.
}
  \item{models}{ list of models (specified as list of edgelists see
    \code{\link{HybridModel}}).
}
  \item{data}{ data.frame containing the data for the model selection
}
  \item{q.cols}{ columns that contain the q-values from the single trait
    analysis to select the marker location that is associated most strongly.
}
  \item{fname}{
    filename to write the results to
}
  \item{n.bootstrap}{
    number of bootstrap samples to draw
}
  \item{redo}{
    redo the analysis or just load the results from the file \code{fname}
}
  \item{covar}{
    additional covariate column to be included in the data.frame for
    model selection.
}
}
\details{

}
\value{
  Returns a data.frame with the following columns:
  \item{gene}{ Gene name for which the models were evaluated }
  \item{marker}{ The genetic marker which was selected for the gene }
  \item{model}{ The name of the model }
  \item{n.param}{ Number of parameters of the model }
  \item{-2*logLik}{ -2 * loklikelihood of the model }
  \item{AIC}{ Akaike information criterion }
  \item{BIC}{ Bayesian information criterion }
  \item{bs.counts}{ Number of times this model was selected as best
    (smallest AIC) among the competing models during the bootstrapping  }
  \item{bs.prob}{ Bootstrap probability of the model (\code{bs.counts / n.bootstrap}
  }

}
\references{
%% ~put references to the literature/web site here ~
}
\author{
%%  ~~who you are~~
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{

data(histoneQTLModels)
data(histoneQTLData)
genes = head(unique(histoneQTLData[,"trait"]))
modelSelection = single.locus.bootstrap(genes, models, histoneQTLData, q.cols=c("eqtl_q", "k4qtl_q", "k27qtl_q"), "histoneQTLModelSelection.txt", 100)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
