\name{logLik.HybridModel}
\alias{logLik.HybridModel}
\title{
Compute the loglikelihood of the model.
}
\description{
Compute the loglikelihood of the model.
}
\usage{
logLik.HybridModel(model, data)
}
\arguments{
  \item{model}{
    a HybridModel object (as fitted by the function \code{\link{fit}})
}
  \item{data}{
    a data.frame containing the data.
}
}
\details{
  
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
%%  ~~who you are~~
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (model, data) 
{
    logLik.Linear <- function(x, data) logLik(x$model)
    logLik.Multinomial <- function(x, data) {
        sum(log(x$freq) * table(data[, x$node]))
    }
    logLik.Normal <- function(x, data) {
        sum(dnorm(data[, x$node], mean = x$mean, sd = x$sigma, 
            log = T))
    }
    ll = sum(sapply(model$distributions, function(x) {
        l = switch(class(x), Linear = logLik.Linear(x, data), 
            Multinomial = logLik.Multinomial(x, data), Normal = logLik.Normal(x, 
                data))
        return(l)
    }))
    return(ll)
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
