\name{information.criteria}
\alias{information.criteria}
\title{
Compute Akaike and Bayes information criteria
}
\description{
Compute Akaike and Bayes information criteria
}
\usage{
information.criteria(edges, data)
}

\arguments{
  \item{edges}{
    a matrix with 2 columns, either numeric or
    character. Each row represents a directed edge in the graph. The first
    column specifies the source node, the second the destination node of
    an edge. 
}
  \item{data}{
    a data.frame containing the data. The type of distribution for each
    column is chosen automatically: if the column holds a factor the
    distribution is discrete; if the column is numeric the distribution
    is continuous. According to the graph structure it is chosen to be
    Linear or Normal.
}
}
\details{
  This function performs model fitting and likelihood computation from
  the data using just the model graph and the data.
}
\value{
  Returns the loglikelihood, Akaike and Bayes information criteria.
}
\references{

}
\author{

}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (edges, data) 
{
    m = fit(edges, data)
    l = -2 * logLik.HybridModel(m, data)
    AIC = 2 * m$n.param + l
    BIC = log(nrow(data)) * m$n.param + l
    return(c(n.param = m$n.param, `-2*logLik` = l, AIC = AIC, 
        BIC = BIC))
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
