\name{generate}
\alias{generate}

\title{
Generate a random sample from a HybridModel.
}
\description{
Generate a random sample from a HybridModel.
}
\usage{
generate(model, nsamples, data = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model}{
%%     ~~Describe \code{model} here~~
}
  \item{nsamples}{
%%     ~~Describe \code{nsamples} here~~
}
  \item{data}{
%%     ~~Describe \code{data} here~~
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
%%  ~~who you are~~
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (model, nsamples, data = NULL) 
{
    switch(class(model), Normal = rnorm(nsamples, mean = model$mean, 
        sd = model$sigma), Multinomial = {
        n = rmultinom(1, size = nsamples, prob = model$freq)
        x = c()
        for (i in 1:length(model$levels)) {
            x = c(x, rep(model$levels[i], n[i]))
        }
        factor(x[sample(1:nsamples, size = nsamples)])
    }, Linear = {
        stopifnot(nrow(data) == nsamples)
        cols = which(sapply(colnames(data), function(cn) length(grep(cn, 
            names(model$beta))) > 0))
        X = model.matrix(~., data = data[, cols, drop = F])
        y = X \%*\% model$beta[colnames(X)]
        rnorm(nsamples, mean = y, sd = model$sigma)
    }, HybridModel = {
        data = data.frame(matrix(ncol = 0, nrow = nsamples))
        orphans = setdiff(model$nodes, model$edges[, 2])
        for (node in orphans) {
            data = data.frame(data, generate(model$distributions[[node]], 
                nsamples))
            colnames(data)[ncol(data)] = node
        }
        rest = model$topological.order[!model$topological.order \%in\% 
            orphans]
        for (node in rest) {
            data = data.frame(data, generate(model$distributions[[node]], 
                nsamples, data))
            colnames(data)[ncol(data)] = node
        }
        return(data)
    })
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
