\name{fit}
\alias{fit}

\title{
Fit the model parameters using maximumlikelihood.
}
\description{
Fit the model parameters using maximumlikelihood.
}
\usage{
fit(edges, data, nodes = NULL)
}

\arguments{
  \item{edges}{
    a matrix with 2 columns, either numeric or
    character. Each row represents a directed edge in the graph. The first
    column specifies the source node, the second the destination node of
    an edge. 
}
  \item{data}{
    a data.frame containing the data. The type of distribution for each
    column is chosen automatically: if the column holds a factor the
    distribution is discrete; if the column is numeric the distribution
    is continuous. According to the graph structure it is chosen to be
    Linear or Normal.
}
  \item{nodes}{
    a vector of nodes (either numeric or character) in the graph. If
    this is NULL the colnames of the data will be used as node names.
}
}
\details{
  This function performs model fitting using just the model graph and the data.
}
\value{
  Returns a fitted HybridModel object.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
%%  ~~who you are~~
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (edges, data, nodes = NULL) 
{
    if (is.null(nodes)) {
        nodes = colnames(data)
    }
    model = HybridModel(edges, nodes, list())
    orphans = setdiff(nodes, edges[, 2])
    for (node in orphans) {
        if (is.factor(data[, node])) {
            model$nodeTypes[node] = "discrete"
            model$distributions[[node]] = Multinomial(node, table(data[, 
                node]), levels(data[, node]))
        }
        else {
            model$distributions[[node]] = Normal(node, mean(data[, 
                node]), sd(data[, node]))
        }
    }
    for (node in setdiff(nodes, orphans)) {
        m = lm(as.formula(paste(node, "~", paste(parents(edges, 
            node), collapse = "+"))), data = data)
        model$distributions[[node]] = Linear(node, m)
    }
    model$n.param = sum(sapply(model$distributions, "[[", "n.param"))
    return(model)
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
